/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.bytes;

import at.favre.lib.bytes.BytesValidator;
import java.util.Arrays;
import java.util.Collections;

public final class BytesValidators {
    private BytesValidators() {
    }

    public static BytesValidator atLeast(int byteLength) {
        int n;
        return new BytesValidator.Length(n, BytesValidator.Length.Mode.GREATER_OR_EQ_THAN);
    }

    public static BytesValidator atMost(int byteLength) {
        int n;
        return new BytesValidator.Length(n, BytesValidator.Length.Mode.SMALLER_OR_EQ_THAN);
    }

    public static BytesValidator exactLength(int byteLength) {
        int n;
        return new BytesValidator.Length(n, BytesValidator.Length.Mode.EXACT);
    }

    public static BytesValidator onlyOf(byte refByte) {
        byte by;
        return new BytesValidator.IdenticalContent(by, BytesValidator.IdenticalContent.Mode.ONLY_OF$62bc4116);
    }

    public static BytesValidator notOnlyOf(byte refByte) {
        byte by;
        return new BytesValidator.IdenticalContent(by, BytesValidator.IdenticalContent.Mode.NOT_ONLY_OF$62bc4116);
    }

    public static BytesValidator startsWith(byte ... startsWithBytes) {
        byte[] byArray;
        return new BytesValidator.PrePostFix(true, byArray);
    }

    public static BytesValidator endsWith(byte ... endsWithBytes) {
        byte[] byArray;
        return new BytesValidator.PrePostFix(false, byArray);
    }

    public static BytesValidator noneOf(byte refByte) {
        byte by;
        return new BytesValidator.IdenticalContent(by, BytesValidator.IdenticalContent.Mode.NONE_OF$62bc4116);
    }

    public static BytesValidator or(BytesValidator ... validators) {
        BytesValidator[] bytesValidatorArray;
        return new BytesValidator.Logical(Arrays.asList(bytesValidatorArray), BytesValidator.Logical.Operator.OR);
    }

    public static BytesValidator and(BytesValidator ... validators) {
        BytesValidator[] bytesValidatorArray;
        return new BytesValidator.Logical(Arrays.asList(bytesValidatorArray), BytesValidator.Logical.Operator.AND);
    }

    public static BytesValidator not(BytesValidator validator) {
        BytesValidator bytesValidator;
        return new BytesValidator.Logical(Collections.singletonList(bytesValidator), BytesValidator.Logical.Operator.NOT);
    }
}

