/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.bytes;

import at.favre.lib.bytes.Bytes;
import at.favre.lib.bytes.Util;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

public interface BytesTransformer {
    public byte[] transform(byte[] var1, boolean var2);

    public boolean supportInPlaceTransformation();

    public static class MessageDigestTransformer
    implements BytesTransformer {
        private final MessageDigest messageDigest;

        /*
         * WARNING - void declaration
         */
        MessageDigestTransformer(String digestName) {
            try {
                this.messageDigest = MessageDigest.getInstance(digestName);
                return;
            }
            catch (NoSuchAlgorithmException e) {
                void var2_2;
                void var1_1;
                throw new IllegalArgumentException("could not get message digest algorithm ".concat(String.valueOf(var1_1)), (Throwable)var2_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public byte[] transform(byte[] currentArray, boolean inPlace) {
            void var1_1;
            this.messageDigest.update((byte[])var1_1);
            return this.messageDigest.digest();
        }

        @Override
        public boolean supportInPlaceTransformation() {
            return false;
        }
    }

    public static class BitSwitchTransformer
    implements BytesTransformer {
        private final int position;
        private final Boolean newBitValue;

        /*
         * WARNING - void declaration
         */
        BitSwitchTransformer(int position, Boolean newBitValue) {
            void var2_2;
            void var1_1;
            this.position = var1_1;
            this.newBitValue = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public byte[] transform(byte[] currentArray, boolean inPlace) {
            void var2_4;
            byte[] out;
            byte[] byArray = out = inPlace ? currentArray : Bytes.from(currentArray).array();
            if (this.position < 0 || this.position >= 8 * currentArray.length) {
                throw new IllegalArgumentException("bit index " + this.position * 8 + " out of bounds");
            }
            int bytePosition = currentArray.length - 1 - this.position / 8;
            if (this.newBitValue == null) {
                int n = bytePosition;
                out[n] = (byte)(out[n] ^ 1 << this.position % 8);
            } else if (this.newBitValue.booleanValue()) {
                int n = bytePosition;
                out[n] = (byte)(out[n] | 1 << this.position % 8);
            } else {
                void var1_2;
                void v3 = var1_2;
                out[v3] = (byte)(out[v3] & ~(1 << this.position % 8));
            }
            return var2_4;
        }

        @Override
        public boolean supportInPlaceTransformation() {
            return true;
        }
    }

    public static final class ResizeTransformer
    implements BytesTransformer {
        private final int newSize;
        private final Mode mode;

        /*
         * WARNING - void declaration
         */
        ResizeTransformer(int newSize, Mode mode) {
            void var2_2;
            void var1_1;
            this.newSize = var1_1;
            this.mode = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte[] transform(byte[] currentArray, boolean inPlace) {
            void var2_3;
            if (currentArray.length == this.newSize) {
                return currentArray;
            }
            if (this.newSize < 0) {
                throw new IllegalArgumentException("cannot resize to smaller than 0");
            }
            if (this.newSize == 0) {
                return new byte[0];
            }
            byte[] resizedArray = new byte[this.newSize];
            if (this.mode == Mode.RESIZE_KEEP_FROM_MAX_LENGTH) {
                if (this.newSize > currentArray.length) {
                    System.arraycopy(currentArray, 0, resizedArray, Math.max(0, Math.abs(this.newSize - currentArray.length)), Math.min(this.newSize, currentArray.length));
                } else {
                    System.arraycopy(currentArray, Math.max(0, Math.abs(this.newSize - currentArray.length)), resizedArray, Math.min(0, Math.abs(this.newSize - currentArray.length)), Math.min(this.newSize, currentArray.length));
                }
            } else {
                void var1_1;
                System.arraycopy(currentArray, 0, resizedArray, 0, Math.min(((void)var1_1).length, resizedArray.length));
            }
            return var2_3;
        }

        @Override
        public final boolean supportInPlaceTransformation() {
            return false;
        }

        public static enum Mode {
            RESIZE_KEEP_FROM_ZERO_INDEX,
            RESIZE_KEEP_FROM_MAX_LENGTH;

        }
    }

    public static final class CopyTransformer
    implements BytesTransformer {
        final int offset;
        final int length;

        /*
         * WARNING - void declaration
         */
        CopyTransformer(int offset, int length) {
            void var2_2;
            void var1_1;
            this.offset = var1_1;
            this.length = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte[] transform(byte[] currentArray, boolean inPlace) {
            void var2_3;
            void var1_1;
            byte[] copy = new byte[this.length];
            System.arraycopy(var1_1, this.offset, copy, 0, copy.length);
            return var2_3;
        }

        @Override
        public final boolean supportInPlaceTransformation() {
            return false;
        }
    }

    public static final class ReverseTransformer
    implements BytesTransformer {
        /*
         * WARNING - void declaration
         */
        @Override
        public final byte[] transform(byte[] currentArray, boolean inPlace) {
            void var1_1;
            byte[] out = inPlace ? currentArray : Bytes.from(currentArray).array();
            int n = out.length;
            byte[] byArray = out;
            Objects.requireNonNull(out);
            --n;
            for (int i = 0; i < n; ++i, --n) {
                byte by = byArray[i];
                byArray[i] = byArray[n];
                byArray[n] = by;
            }
            return var1_1;
        }

        @Override
        public final boolean supportInPlaceTransformation() {
            return true;
        }
    }

    public static final class ConcatTransformer
    implements BytesTransformer {
        private final byte[] secondArray;

        /*
         * WARNING - void declaration
         */
        ConcatTransformer(byte[] secondArrays) {
            void var1_1;
            this.secondArray = (byte[])Objects.requireNonNull(var1_1, "the second byte array must not be null");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte[] transform(byte[] currentArray, boolean inPlace) {
            void var1_1;
            return Util.Byte.concat(new byte[][]{var1_1, this.secondArray});
        }

        @Override
        public final boolean supportInPlaceTransformation() {
            return false;
        }
    }

    public static final class ShiftTransformer
    implements BytesTransformer {
        private final int shiftCount;
        private final Type type;

        /*
         * WARNING - void declaration
         */
        ShiftTransformer(int shiftCount, Type type) {
            void var2_2;
            void var1_1;
            this.shiftCount = var1_1;
            this.type = (Type)Objects.requireNonNull(var2_2, "passed shift type must not be null");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte[] transform(byte[] currentArray, boolean inPlace) {
            void var1_1;
            int n;
            byte[] out = inPlace ? currentArray : Bytes.from(currentArray).array();
            switch (this.type) {
                case RIGHT_SHIFT: {
                    n = this.shiftCount;
                    int n2 = n % 8;
                    byte by = (byte)(255 << 8 - n2);
                    n /= 8;
                    for (int i = out.length - 1; i >= 0; --i) {
                        int n3 = i - n;
                        if (n3 < 0) {
                            out[i] = 0;
                            continue;
                        }
                        byte by2 = out[n3];
                        by2 = (byte)((0xFF & by2) >>> n2);
                        if (n3 - 1 >= 0) {
                            by2 = (byte)(by2 | out[n3 - 1] << 8 - n2 & by);
                        }
                        out[i] = by2;
                    }
                    return out;
                }
            }
            n = this.shiftCount;
            int n4 = n % 8;
            byte by = (byte)((1 << n4) - 1);
            n /= 8;
            for (int i = 0; i < ((void)var1_1).length; ++i) {
                int n5 = i + n;
                if (n5 >= ((void)var1_1).length) {
                    var1_1[i] = false;
                    continue;
                }
                byte by3 = (byte)(var1_1[n5] << n4);
                if (n5 + 1 < ((void)var1_1).length) {
                    by3 = (byte)(by3 | var1_1[n5 + 1] >>> 8 - n4 & by);
                }
                var1_1[i] = by3;
            }
            return var1_1;
        }

        @Override
        public final boolean supportInPlaceTransformation() {
            return true;
        }

        public static enum Type {
            LEFT_SHIFT,
            RIGHT_SHIFT;

        }
    }

    public static final class NegateTransformer
    implements BytesTransformer {
        /*
         * WARNING - void declaration
         */
        @Override
        public final byte[] transform(byte[] currentArray, boolean inPlace) {
            void var1_1;
            byte[] out = inPlace ? currentArray : Bytes.from(currentArray).array();
            for (int i = 0; i < out.length; ++i) {
                out[i] = ~out[i];
            }
            return var1_1;
        }

        @Override
        public final boolean supportInPlaceTransformation() {
            return true;
        }
    }

    public static final class BitWiseOperatorTransformer
    implements BytesTransformer {
        private final byte[] secondArray;
        private final Mode mode;

        /*
         * WARNING - void declaration
         */
        BitWiseOperatorTransformer(byte[] secondArray, Mode mode) {
            void var2_2;
            void var1_1;
            this.secondArray = (byte[])Objects.requireNonNull(var1_1, "the second byte array must not be null");
            this.mode = (Mode)Objects.requireNonNull(var2_2, "passed bitwise mode must not be null");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte[] transform(byte[] currentArray, boolean inPlace) {
            void var2_3;
            if (currentArray.length != this.secondArray.length) {
                throw new IllegalArgumentException("all byte array must be of same length doing bit wise operation");
            }
            byte[] out = inPlace ? currentArray : new byte[currentArray.length];
            block4: for (int i = 0; i < currentArray.length; ++i) {
                switch (this.mode) {
                    case AND: {
                        out[i] = (byte)(currentArray[i] & this.secondArray[i]);
                        continue block4;
                    }
                    case XOR: {
                        out[i] = (byte)(currentArray[i] ^ this.secondArray[i]);
                        continue block4;
                    }
                    default: {
                        out[i] = (byte)(currentArray[i] | this.secondArray[i]);
                    }
                }
            }
            return var2_3;
        }

        @Override
        public final boolean supportInPlaceTransformation() {
            return true;
        }

        public static enum Mode {
            AND,
            OR,
            XOR;

        }
    }
}

