/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.bytes;

import at.favre.lib.bytes.BinaryToTextEncoding;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Objects;

final class BaseEncoding
implements BinaryToTextEncoding.EncoderDecoder {
    static final Alphabet BASE32_RFC4848 = new Alphabet("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567".toCharArray());
    private final Alphabet alphabet;
    private final Character paddingChar;

    /*
     * WARNING - void declaration
     */
    public BaseEncoding(Alphabet alphabet, Character paddingChar) {
        void var2_2;
        void var1_1;
        this.alphabet = (Alphabet)Objects.requireNonNull(var1_1);
        this.paddingChar = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String encode(byte[] array, ByteOrder byteOrder) {
        void var1_1;
        void v0 = var1_1;
        return this.encode$55a39fc4((byte[])v0, ((void)v0).length);
    }

    /*
     * WARNING - void declaration
     */
    private String encode$55a39fc4(byte[] bytes, int len) {
        void var3_7;
        int n = len;
        BaseEncoding off22 = this;
        int n2 = n;
        int off22 = n2;
        n = off22.alphabet.bytesPerChunk;
        int n3 = n2 / n;
        StringBuilder result = new StringBuilder(off22.alphabet.charsPerChunk * (off22 - n * n3 != 0 && (off22 = 1 | (off22 ^ n) >> 31) > 0 ? n3 + off22 : n3));
        try {
            void var2_3;
            this.encodeTo$539cc6dd(result, bytes, (int)var2_3);
        }
        catch (IOException impossible) {
            void var1_2;
            throw new AssertionError(var1_2);
        }
        return var3_7.toString();
    }

    private void encodeTo$539cc6dd(Appendable target, byte[] bytes, int len) throws IOException {
        Objects.requireNonNull(target);
        for (int i = 0; i < len; i += this.alphabet.bytesPerChunk) {
            int n;
            int n2;
            int n3 = Math.min(this.alphabet.bytesPerChunk, len - i);
            int n4 = 0 + i;
            byte[] byArray = bytes;
            Appendable appendable = target;
            BaseEncoding baseEncoding = this;
            Objects.requireNonNull(appendable);
            long l = 0L;
            for (n2 = 0; n2 < n3; ++n2) {
                l = (l | (long)(byArray[n4 + n2] & 0xFF)) << 8;
            }
            n2 = (n3 + 1) * 8 - baseEncoding.alphabet.bitsPerChar;
            for (n = 0; n < n3 * 8; n += baseEncoding.alphabet.bitsPerChar) {
                n4 = (int)(l >>> n2 - n) & baseEncoding.alphabet.mask;
                appendable.append(baseEncoding.alphabet.encode(n4));
            }
            if (baseEncoding.paddingChar == null) continue;
            while (n < baseEncoding.alphabet.bytesPerChunk * 8) {
                appendable.append(baseEncoding.paddingChar.charValue());
                n += baseEncoding.alphabet.bitsPerChar;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private String trimTrailingPadding(CharSequence chars) {
        void var2_2;
        void var1_1;
        Objects.requireNonNull(chars);
        if (this.paddingChar == null) {
            return chars.toString();
        }
        for (int l = chars.length() - 1; l >= 0 && chars.charAt(l) == this.paddingChar.charValue(); --l) {
        }
        return var1_1.subSequence(0, (int)(var2_2 + true)).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final byte[] decode(CharSequence encoded) {
        void var2_7;
        void var1_2;
        byte[] tmp;
        encoded = this.trimTrailingPadding(encoded);
        int n = encoded.length();
        byte[] byArray = tmp = new byte[(int)(((long)this.alphabet.bitsPerChar * (long)n + 7L) / 8L)];
        BaseEncoding baseEncoding = this;
        Objects.requireNonNull(byArray);
        encoded = baseEncoding.trimTrailingPadding(encoded);
        int n2 = 0;
        for (int i = 0; i < encoded.length(); i += baseEncoding.alphabet.charsPerChunk) {
            int n3;
            long l = 0L;
            int n4 = 0;
            for (n3 = 0; n3 < baseEncoding.alphabet.charsPerChunk; ++n3) {
                l <<= baseEncoding.alphabet.bitsPerChar;
                if (i + n3 >= encoded.length()) continue;
                l |= (long)baseEncoding.alphabet.decode(encoded.charAt(i + n4++));
            }
            n3 = baseEncoding.alphabet.bytesPerChunk * 8 - n4 * baseEncoding.alphabet.bitsPerChar;
            for (n4 = (baseEncoding.alphabet.bytesPerChunk - 1) * 8; n4 >= n3; n4 -= 8) {
                byArray[n2++] = (byte)(l >>> n4 & 0xFFL);
            }
        }
        int len = n2;
        void var4_6 = var1_2;
        baseEncoding = var2_7;
        if (var4_6 == ((BaseEncoding)baseEncoding).length) {
            return baseEncoding;
        }
        byte[] byArray2 = new byte[var4_6];
        System.arraycopy(baseEncoding, 0, byArray2, 0, (int)var4_6);
        return byArray2;
    }

    static /* synthetic */ int access$000(int x0) {
        int n;
        return 31 - Integer.numberOfLeadingZeros(n);
    }

    static final class Alphabet {
        private final char[] chars;
        final int mask;
        final int bitsPerChar;
        final int charsPerChunk;
        final int bytesPerChunk;
        private final byte[] decodabet;

        /*
         * WARNING - void declaration
         */
        Alphabet(char[] chars) {
            void var2_3;
            this.chars = Objects.requireNonNull(chars);
            this.bitsPerChar = BaseEncoding.access$000(chars.length);
            int gcd = Math.min(8, Integer.lowestOneBit(this.bitsPerChar));
            this.charsPerChunk = 8 / gcd;
            this.bytesPerChunk = this.bitsPerChar / gcd;
            this.mask = chars.length - 1;
            byte[] decodabet = new byte[128];
            Arrays.fill(decodabet, (byte)-1);
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                decodabet[c] = (byte)i;
            }
            this.decodabet = var2_3;
        }

        /*
         * WARNING - void declaration
         */
        final char encode(int bits) {
            void var1_1;
            return this.chars[var1_1];
        }

        /*
         * WARNING - void declaration
         */
        final int decode(char ch) {
            void var1_1;
            return this.decodabet[var1_1];
        }
    }
}

