/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.bytes;

import at.favre.lib.bytes.BaseEncoding;
import at.favre.lib.bytes.BinaryToTextEncoding;
import at.favre.lib.bytes.BytesFactory;
import at.favre.lib.bytes.BytesTransformer;
import at.favre.lib.bytes.BytesValidator;
import at.favre.lib.bytes.BytesValidators;
import at.favre.lib.bytes.MutableBytes;
import at.favre.lib.bytes.ReadOnlyBytes;
import at.favre.lib.bytes.Util;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;

public class Bytes
implements Serializable,
Comparable<Bytes>,
Iterable<Byte> {
    private static final Bytes EMPTY = Bytes.wrap(new byte[0]);
    private final byte[] byteArray;
    private final ByteOrder byteOrder;
    private final BytesFactory factory;
    private transient int hashCodeCache;

    public static Bytes allocate(int length) {
        return Bytes.allocate(length, (byte)0);
    }

    /*
     * WARNING - void declaration
     */
    public static Bytes allocate(int length, byte defaultValue) {
        void var0_1;
        if (length == 0) {
            return Bytes.empty();
        }
        byte[] array = new byte[length];
        if (defaultValue != 0) {
            void var1_2;
            Arrays.fill(array, (byte)var1_2);
        }
        return Bytes.wrap((byte[])var0_1);
    }

    public static Bytes empty() {
        return EMPTY;
    }

    public static Bytes wrap(Bytes bytes) {
        Bytes bytes2;
        return Bytes.wrap(bytes.byteArray, bytes2.byteOrder);
    }

    public static Bytes wrapNullSafe(byte[] array) {
        if (array != null) {
            byte[] byArray;
            return Bytes.wrap(byArray);
        }
        return Bytes.empty();
    }

    public static Bytes wrap(byte[] array) {
        return Bytes.wrap(array, ByteOrder.BIG_ENDIAN);
    }

    /*
     * WARNING - void declaration
     */
    public static Bytes wrap(byte[] array, ByteOrder byteOrder) {
        void var1_1;
        byte[] byArray;
        return new Bytes(Objects.requireNonNull(byArray, "passed array must not be null"), (ByteOrder)var1_1);
    }

    public static Bytes from(byte[] byteArrayToCopy) {
        byte[] byArray;
        return Bytes.wrap(Arrays.copyOf(Objects.requireNonNull(byteArrayToCopy, "must at least pass a single byte"), byArray.length));
    }

    public static Bytes fromNullSafe(byte[] byteArrayToCopy) {
        if (byteArrayToCopy != null) {
            byte[] byArray;
            return Bytes.from(byArray);
        }
        return Bytes.empty();
    }

    /*
     * WARNING - void declaration
     */
    public static Bytes from(byte[] array, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        byte[] byArray;
        Objects.requireNonNull(array, "passed array must not be null");
        byte[] part = new byte[length];
        System.arraycopy(byArray, (int)var1_1, part, 0, (int)var2_2);
        return Bytes.wrap((byte[])var3_3);
    }

    public static Bytes from(byte[] ... moreArrays) {
        return Bytes.wrap(Util.Byte.concat(moreArrays));
    }

    /*
     * WARNING - void declaration
     */
    public static Bytes from(Bytes ... moreBytes) {
        void var1_1;
        Objects.requireNonNull(moreBytes, "bytes most not be null");
        byte[][] bytes = new byte[moreBytes.length][];
        for (int i = 0; i < moreBytes.length; ++i) {
            bytes[i] = moreBytes[i].array();
        }
        return Bytes.from((byte[][])var1_1);
    }

    public static Bytes from(Collection<Byte> bytesCollection) {
        Iterator<Byte> iterator;
        byte[] byArray = new byte[bytesCollection.size()];
        int n = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Byte by = (Byte)iterator.next();
            byArray[n] = by;
            ++n;
        }
        return Bytes.wrap(byArray);
    }

    public static Bytes from(Byte[] boxedObjectArray) {
        Byte[] byteArray;
        byte[] byArray = new byte[boxedObjectArray.length];
        for (int i = 0; i < byteArray.length; ++i) {
            byArray[i] = byteArray[i];
        }
        return Bytes.wrap(byArray);
    }

    public static Bytes from(byte singleByte) {
        byte by;
        return Bytes.wrap(new byte[]{by});
    }

    /*
     * WARNING - void declaration
     */
    public static Bytes from(byte firstByte, byte ... moreBytes) {
        byte by;
        byte[] byArray;
        if (moreBytes == null) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = by;
        } else {
            void var1_1;
            byArray = Util.Byte.concat(new byte[][]{{by}, var1_1});
        }
        return Bytes.wrap(byArray);
    }

    public static Bytes from(boolean booleanValue) {
        boolean bl;
        return Bytes.wrap(new byte[]{bl ? (byte)1 : 0});
    }

    public static Bytes from(char char2Byte) {
        char c;
        return Bytes.wrap(ByteBuffer.allocate(2).putChar(c).array());
    }

    public static Bytes from(short short2Byte) {
        short s;
        return Bytes.wrap(ByteBuffer.allocate(2).putShort(s).array());
    }

    public static Bytes from(int integer4byte) {
        int n;
        return Bytes.wrap(ByteBuffer.allocate(4).putInt(n).array());
    }

    public static Bytes from(int ... intArray) {
        int[] nArray = Objects.requireNonNull(intArray, "must provide at least a single int");
        byte[] byArray = new byte[nArray.length * 4];
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        for (int i = 0; i < nArray.length; ++i) {
            byteBuffer.clear();
            byte[] byArray2 = byteBuffer.putInt(nArray[i]).array();
            System.arraycopy(byArray2, 0, byArray, i * 4, byArray2.length);
        }
        return Bytes.wrap(byArray);
    }

    public static Bytes from(long long8byte) {
        long l;
        return Bytes.wrap(ByteBuffer.allocate(8).putLong(l).array());
    }

    public static Bytes from(long ... longArray) {
        long[] lArray = Objects.requireNonNull(longArray, "must provide at least a single long");
        byte[] byArray = new byte[lArray.length * 8];
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        for (int i = 0; i < lArray.length; ++i) {
            byteBuffer.clear();
            byte[] byArray2 = byteBuffer.putLong(lArray[i]).array();
            System.arraycopy(byArray2, 0, byArray, i * 8, byArray2.length);
        }
        return Bytes.wrap(byArray);
    }

    public static Bytes from(float float4byte) {
        float f;
        return Bytes.wrap(ByteBuffer.allocate(4).putFloat(f).array());
    }

    public static Bytes from(double double8Byte) {
        double d;
        return Bytes.wrap(ByteBuffer.allocate(8).putDouble(d).array());
    }

    public static Bytes from(ByteBuffer buffer) {
        ByteBuffer byteBuffer;
        return Bytes.wrap(Objects.requireNonNull(buffer, "provided byte buffer must not be null").array(), byteBuffer.order());
    }

    public static Bytes from(CharBuffer buffer) {
        return Bytes.from(Objects.requireNonNull(buffer, "provided char buffer must not be null").array());
    }

    public static Bytes from(IntBuffer buffer) {
        return Bytes.from(Objects.requireNonNull(buffer, "provided int buffer must not be null").array());
    }

    public static Bytes from(BitSet set) {
        return Bytes.wrap(set.toByteArray());
    }

    public static Bytes from(BigInteger bigInteger) {
        return Bytes.wrap(bigInteger.toByteArray());
    }

    public static Bytes from(InputStream stream) {
        return Bytes.wrap(Util.File.readFromStream(stream, -1));
    }

    /*
     * WARNING - void declaration
     */
    public static Bytes from(InputStream stream, int maxLength) {
        void var1_1;
        return Bytes.wrap(Util.File.readFromStream(stream, (int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static Bytes from(DataInput dataInput, int length) {
        void var1_1;
        return Bytes.wrap(Util.File.readFromDataInput(dataInput, (int)var1_1));
    }

    public static Bytes from(File file) {
        return Bytes.wrap(Util.File.readFromFile(file));
    }

    /*
     * WARNING - void declaration
     */
    public static Bytes from(File file, int offset, int length) {
        void var2_2;
        void var1_1;
        return Bytes.wrap(Util.File.readFromFile(file, (int)var1_1, (int)var2_2));
    }

    public static Bytes from(CharSequence utf8String) {
        return Bytes.from(utf8String, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public static Bytes from(CharSequence utf8String, Normalizer.Form form) {
        void var1_1;
        return Bytes.from((CharSequence)Normalizer.normalize(utf8String, (Normalizer.Form)var1_1), StandardCharsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public static Bytes from(CharSequence string, Charset charset) {
        void var1_1;
        return Bytes.wrap(Objects.requireNonNull(string, "provided string must not be null").toString().getBytes((Charset)Objects.requireNonNull(var1_1, "provided charset must not be null")));
    }

    public static Bytes from(char[] charArray) {
        return Bytes.from(charArray, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public static Bytes from(char[] charArray, Charset charset) {
        char[] cArray;
        void var1_1;
        return Bytes.from(charArray, (Charset)var1_1, 0, cArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static Bytes from(char[] charArray, Charset charset, int offset, int length) {
        byte[] byArray;
        void var3_3;
        void var2_2;
        Object object = charArray;
        if (var2_2 < 0 || var2_2 > ((char[])object).length) {
            throw new IllegalArgumentException("offset must be gt 0 and smaller than array length");
        }
        if (var3_3 < 0 || var3_3 > ((char[])object).length) {
            throw new IllegalArgumentException("length must be at least 1 and less than array length");
        }
        if (var2_2 + var3_3 > ((char[])object).length) {
            throw new IllegalArgumentException("length + offset must be smaller than array length");
        }
        if (var3_3 == false) {
            byArray = new byte[]{};
        } else {
            byte[] byArray2;
            object = CharBuffer.wrap((char[])object);
            if (var2_2 != false || var3_3 != ((Buffer)object).remaining()) {
                void v1 = var2_2;
                object = ((CharBuffer)object).subSequence((int)v1, (int)(v1 + var3_3));
            }
            if (((Buffer)(object = byArray2.encode((CharBuffer)object))).capacity() != ((Buffer)object).limit()) {
                byArray2 = new byte[((Buffer)object).remaining()];
                ((ByteBuffer)object).get(byArray2);
                byArray = byArray2;
            } else {
                byArray = ((ByteBuffer)object).array();
            }
        }
        return Bytes.from(byArray);
    }

    public static Bytes from(UUID uuid) {
        UUID uUID = Objects.requireNonNull(uuid);
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        byteBuffer.putLong(uUID.getMostSignificantBits());
        byteBuffer.putLong(uUID.getLeastSignificantBits());
        return Bytes.wrap(byteBuffer.array());
    }

    public static Bytes parseBinary(CharSequence binaryString) {
        return Bytes.parseRadix(binaryString, 2);
    }

    public static Bytes parseOctal(CharSequence octalString) {
        return Bytes.parseRadix(octalString, 8);
    }

    public static Bytes parseDec(CharSequence decString) {
        return Bytes.parseRadix(decString, 10);
    }

    /*
     * WARNING - void declaration
     */
    public static Bytes parseRadix(CharSequence radixNumberString, int radix) {
        void var1_1;
        return Bytes.parse(radixNumberString, new BinaryToTextEncoding.BaseRadixNumber((int)var1_1));
    }

    public static Bytes parseHex(CharSequence hexString) {
        return Bytes.parse(hexString, new BinaryToTextEncoding.Hex());
    }

    public static Bytes parseBase32(CharSequence base32Rfc4648String) {
        return Bytes.parse(base32Rfc4648String, new BaseEncoding(BaseEncoding.BASE32_RFC4848, Character.valueOf('=')));
    }

    @Deprecated
    public static Bytes parseBase36(CharSequence base36String) {
        return Bytes.parse(base36String, new BinaryToTextEncoding.BaseRadixNumber(36));
    }

    public static Bytes parseBase64(CharSequence base64String) {
        return Bytes.parse(base64String, new BinaryToTextEncoding.Base64Encoding());
    }

    public static Bytes parse(CharSequence encoded, BinaryToTextEncoding.Decoder decoder) {
        CharSequence charSequence;
        return Bytes.wrap(Objects.requireNonNull(decoder, "passed decoder instance must no be null").decode(Objects.requireNonNull(charSequence, "encoded data must not be null")));
    }

    public static Bytes random(int length) {
        return Bytes.random(length, new SecureRandom());
    }

    public static Bytes unsecureRandom(int length) {
        return Bytes.random(length, new Random());
    }

    /*
     * WARNING - void declaration
     */
    public static Bytes unsecureRandom(int length, long seed) {
        void var1_1;
        return Bytes.random(length, new Random((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static Bytes random(int length, Random random) {
        void var0_1;
        void var1_2;
        byte[] array = new byte[length];
        var1_2.nextBytes(array);
        return Bytes.wrap((byte[])var0_1);
    }

    /*
     * WARNING - void declaration
     */
    Bytes(byte[] byteArray, ByteOrder byteOrder) {
        this((byte[])var1_1, (ByteOrder)var2_2, new Factory(0));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    Bytes(byte[] byteArray, ByteOrder byteOrder, BytesFactory factory) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.byteArray = var1_1;
        this.byteOrder = var2_2;
        this.factory = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Bytes append(Bytes bytes) {
        void var1_1;
        return this.append(var1_1.byteArray);
    }

    /*
     * WARNING - void declaration
     */
    public Bytes append(byte singleByte) {
        void var1_1;
        return this.append(Bytes.from((byte)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Bytes append(char char2Bytes) {
        void var1_1;
        return this.append(Bytes.from((char)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Bytes append(short short2Bytes) {
        void var1_1;
        return this.append(Bytes.from((short)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Bytes append(int integer4Bytes) {
        void var1_1;
        return this.append(Bytes.from((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Bytes append(long long8Bytes) {
        void var1_1;
        return this.append(Bytes.from((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Bytes append(byte[] ... arrays) {
        void var1_1;
        return this.append(Bytes.from((byte[][])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Bytes append(byte[] secondArray) {
        void var1_1;
        return this.transform(new BytesTransformer.ConcatTransformer((byte[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Bytes appendNullSafe(byte[] secondArrayNullable) {
        void var1_1;
        if (secondArrayNullable == null) {
            return this;
        }
        return this.append((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Bytes append(CharSequence stringUtf8) {
        void var1_1;
        return this.append((CharSequence)var1_1, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public Bytes append(CharSequence string, Charset charset) {
        void var2_2;
        void var1_1;
        return this.transform(new BytesTransformer.ConcatTransformer(((CharSequence)Objects.requireNonNull(var1_1)).toString().getBytes((Charset)Objects.requireNonNull(var2_2))));
    }

    /*
     * WARNING - void declaration
     */
    public Bytes xor(Bytes bytes) {
        void var1_1;
        return this.xor(var1_1.byteArray);
    }

    /*
     * WARNING - void declaration
     */
    public Bytes xor(byte[] secondArray) {
        void var1_1;
        return this.transform(new BytesTransformer.BitWiseOperatorTransformer((byte[])var1_1, BytesTransformer.BitWiseOperatorTransformer.Mode.XOR));
    }

    /*
     * WARNING - void declaration
     */
    public Bytes and(Bytes bytes) {
        void var1_1;
        return this.and(var1_1.byteArray);
    }

    /*
     * WARNING - void declaration
     */
    public Bytes and(byte[] secondArray) {
        void var1_1;
        return this.transform(new BytesTransformer.BitWiseOperatorTransformer((byte[])var1_1, BytesTransformer.BitWiseOperatorTransformer.Mode.AND));
    }

    /*
     * WARNING - void declaration
     */
    public Bytes or(Bytes bytes) {
        void var1_1;
        return this.or(var1_1.byteArray);
    }

    /*
     * WARNING - void declaration
     */
    public Bytes or(byte[] secondArray) {
        void var1_1;
        return this.transform(new BytesTransformer.BitWiseOperatorTransformer((byte[])var1_1, BytesTransformer.BitWiseOperatorTransformer.Mode.OR));
    }

    public Bytes not() {
        return this.transform(new BytesTransformer.NegateTransformer());
    }

    /*
     * WARNING - void declaration
     */
    public Bytes leftShift(int shiftCount) {
        void var1_1;
        return this.transform(new BytesTransformer.ShiftTransformer((int)var1_1, BytesTransformer.ShiftTransformer.Type.LEFT_SHIFT));
    }

    /*
     * WARNING - void declaration
     */
    public Bytes rightShift(int shiftCount) {
        void var1_1;
        return this.transform(new BytesTransformer.ShiftTransformer((int)var1_1, BytesTransformer.ShiftTransformer.Type.RIGHT_SHIFT));
    }

    /*
     * WARNING - void declaration
     */
    public Bytes switchBit(int bitPosition, boolean newBitValue) {
        void var2_2;
        void var1_1;
        return this.transform(new BytesTransformer.BitSwitchTransformer((int)var1_1, (boolean)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public Bytes switchBit(int bitPosition) {
        void var1_1;
        return this.transform(new BytesTransformer.BitSwitchTransformer((int)var1_1, null));
    }

    public Bytes copy() {
        return this.transform(new BytesTransformer.CopyTransformer(0, this.length()));
    }

    /*
     * WARNING - void declaration
     */
    public Bytes copy(int offset, int length) {
        void var2_2;
        void var1_1;
        return this.transform(new BytesTransformer.CopyTransformer((int)var1_1, (int)var2_2));
    }

    public Bytes reverse() {
        return this.transform(new BytesTransformer.ReverseTransformer());
    }

    /*
     * WARNING - void declaration
     */
    public Bytes resize(int newByteLength) {
        void var1_1;
        return this.resize((int)var1_1, BytesTransformer.ResizeTransformer.Mode.RESIZE_KEEP_FROM_MAX_LENGTH);
    }

    /*
     * WARNING - void declaration
     */
    public Bytes resize(int newByteLength, BytesTransformer.ResizeTransformer.Mode mode) {
        void var2_2;
        void var1_1;
        return this.transform(new BytesTransformer.ResizeTransformer((int)var1_1, (BytesTransformer.ResizeTransformer.Mode)var2_2));
    }

    public Bytes hashMd5() {
        return this.hash("MD5");
    }

    public Bytes hashSha1() {
        return this.hash("SHA-1");
    }

    public Bytes hashSha256() {
        return this.hash("SHA-256");
    }

    /*
     * WARNING - void declaration
     */
    public Bytes hash(String algorithm) {
        void var1_1;
        return this.transform(new BytesTransformer.MessageDigestTransformer((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Bytes transform(BytesTransformer transformer) {
        void var1_1;
        return this.factory.wrap(var1_1.transform(this.byteArray, this.isMutable()), this.byteOrder);
    }

    public boolean validateNotOnlyZeros() {
        return this.validate(BytesValidators.notOnlyOf((byte)0));
    }

    public boolean validate(BytesValidator ... bytesValidators) {
        return BytesValidators.and(Objects.requireNonNull(bytesValidators)).validate(this.byteArray);
    }

    public int length() {
        return this.byteArray.length;
    }

    public int lengthBit() {
        return this.length() * 8;
    }

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public ByteOrder byteOrder() {
        return this.byteOrder;
    }

    public boolean isMutable() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(byte target) {
        void var1_1;
        return this.indexOf((byte)var1_1) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public int indexOf(byte target) {
        void var1_1;
        return this.indexOf((byte)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public int indexOf(byte target, int fromIndex) {
        void var2_2;
        void var1_1;
        return this.indexOf(new byte[]{var1_1}, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public int indexOf(byte[] subArray) {
        void var1_1;
        return this.indexOf((byte[])var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public int indexOf(byte[] subArray, int fromIndex) {
        void var2_2;
        void var1_1;
        return Util.Byte.indexOf(this.byteArray, (byte[])var1_1, (int)var2_2, this.length());
    }

    /*
     * WARNING - void declaration
     */
    public boolean startsWith(byte[] subArray) {
        void var1_1;
        return Util.Byte.indexOf(this.byteArray, (byte[])var1_1, 0, 1) == 0;
    }

    /*
     * WARNING - void declaration
     */
    public int lastIndexOf(byte target) {
        void var1_1;
        int n = this.length();
        void var2_4 = var1_1;
        byte[] byArray = this.byteArray;
        --n;
        while (n >= 0) {
            if (byArray[n] == var2_4) {
                return n;
            }
            --n;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean endsWith(byte[] subArray) {
        int startIndex = this.length() - subArray.length;
        if (startIndex >= 0) {
            void var2_2;
            void var1_1;
            int n = startIndex;
            if (Util.Byte.indexOf(this.byteArray, (byte[])var1_1, n, n + 1) == var2_2) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean bitAt(int bitIndex) {
        void var1_1;
        Util.Validation.checkIndexBounds(this.lengthBit(), bitIndex, 1, "bit");
        Bytes bytes = this;
        return (bytes.byteAt(bytes.length() - 1 - bitIndex / 8) >>> var1_1 % 8 & 1) != 0;
    }

    /*
     * WARNING - void declaration
     */
    public byte byteAt(int index) {
        void var1_1;
        Util.Validation.checkIndexBounds(this.length(), index, 1, "byte");
        return this.byteArray[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public int unsignedByteAt(int index) {
        void var1_1;
        Util.Validation.checkIndexBounds(this.length(), index, 1, "unsigned byte");
        return 0xFF & this.byteArray[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public char charAt(int index) {
        void var1_1;
        Util.Validation.checkIndexBounds(this.length(), index, 2, "char");
        return ((ByteBuffer)this.internalBuffer().position((int)var1_1)).getChar();
    }

    /*
     * WARNING - void declaration
     */
    public short shortAt(int index) {
        void var1_1;
        Util.Validation.checkIndexBounds(this.length(), index, 2, "short");
        return ((ByteBuffer)this.internalBuffer().position((int)var1_1)).getShort();
    }

    /*
     * WARNING - void declaration
     */
    public int intAt(int index) {
        void var1_1;
        Util.Validation.checkIndexBounds(this.length(), index, 4, "int");
        return ((ByteBuffer)this.internalBuffer().position((int)var1_1)).getInt();
    }

    /*
     * WARNING - void declaration
     */
    public long longAt(int index) {
        void var1_1;
        Util.Validation.checkIndexBounds(this.length(), index, 8, "long");
        return ((ByteBuffer)this.internalBuffer().position((int)var1_1)).getLong();
    }

    /*
     * WARNING - void declaration
     */
    public int count(byte target) {
        void var1_1;
        void var2_3 = var1_1;
        byte[] byArray = this.byteArray;
        int n = 0;
        int n2 = byArray.length;
        for (int i = 0; i < n2; ++i) {
            if (byArray[i] != var2_3) continue;
            ++n;
        }
        return n;
    }

    public int count(byte[] pattern) {
        byte[] byArray;
        void var2_2 = byArray;
        byArray = this.byteArray;
        Objects.requireNonNull(var2_2, "pattern must not be null");
        if (((void)var2_2).length == 0 || byArray.length == 0) {
            return 0;
        }
        int n = 0;
        block0: for (int i = 0; i < byArray.length - ((void)var2_2).length + 1; ++i) {
            for (int j = 0; j < ((void)var2_2).length; ++j) {
                if (byArray[i + j] != var2_2[j]) continue block0;
            }
            ++n;
        }
        return n;
    }

    public double entropy() {
        int n;
        byte[] byArray = this.byteArray;
        int[] nArray = new int[256];
        Arrays.fill(nArray, -1);
        byte[] byArray2 = byArray;
        int n2 = byArray.length;
        for (int i = 0; i < n2; ++i) {
            n = byArray2[i];
            if (nArray[n = 0xFF & n] == -1) {
                nArray[n] = 0;
            }
            int n3 = n;
            nArray[n3] = nArray[n3] + 1;
        }
        double d = 0.0;
        int[] nArray2 = nArray;
        for (n = 0; n < 256; ++n) {
            double d2;
            int n4 = nArray2[n];
            if (n4 == -1) continue;
            double d3 = d2 = (double)n4 / (double)byArray.length;
            d -= d3 * (Math.log(d3) / Math.log(2.0));
        }
        return d;
    }

    public Bytes duplicate() {
        return this.factory.wrap(this.byteArray, this.byteOrder);
    }

    /*
     * WARNING - void declaration
     */
    public Bytes byteOrder(ByteOrder byteOrder) {
        if (byteOrder != this.byteOrder) {
            void var1_1;
            return Bytes.wrap(this.byteArray, (ByteOrder)var1_1);
        }
        return this;
    }

    public ReadOnlyBytes readOnly() {
        if (this.isReadOnly()) {
            return (ReadOnlyBytes)this;
        }
        return new ReadOnlyBytes(this.byteArray, this.byteOrder);
    }

    public ByteBuffer buffer() {
        return ByteBuffer.wrap(this.array()).order(this.byteOrder);
    }

    private ByteBuffer internalBuffer() {
        return ByteBuffer.wrap(this.byteArray).order(this.byteOrder);
    }

    public MutableBytes mutable() {
        if (this instanceof MutableBytes) {
            return (MutableBytes)this;
        }
        return new MutableBytes(this.array(), this.byteOrder);
    }

    public InputStream inputStream() {
        return new ByteArrayInputStream(this.array());
    }

    public byte[] array() {
        return this.byteArray;
    }

    final byte[] internalArray() {
        return this.byteArray;
    }

    public String encodeBinary() {
        return this.encodeRadix(2);
    }

    public String encodeOctal() {
        return this.encodeRadix(8);
    }

    public String encodeDec() {
        return this.encodeRadix(10);
    }

    /*
     * WARNING - void declaration
     */
    public String encodeRadix(int radix) {
        void var1_1;
        return this.encode(new BinaryToTextEncoding.BaseRadixNumber((int)var1_1));
    }

    public String encodeHex() {
        return this.encodeHex(false);
    }

    /*
     * WARNING - void declaration
     */
    public String encodeHex(boolean upperCase) {
        void var1_1;
        return this.encode(new BinaryToTextEncoding.Hex((boolean)var1_1));
    }

    public String encodeBase32() {
        return this.encode(new BaseEncoding(BaseEncoding.BASE32_RFC4848, Character.valueOf('=')));
    }

    @Deprecated
    public String encodeBase36() {
        return this.encodeRadix(36);
    }

    public String encodeBase64() {
        return this.encodeBase64(false, true);
    }

    public String encodeBase64Url() {
        return this.encodeBase64(true, true);
    }

    /*
     * WARNING - void declaration
     */
    public String encodeBase64(boolean urlSafe, boolean withPadding) {
        void var2_2;
        void var1_1;
        return this.encode(new BinaryToTextEncoding.Base64Encoding((boolean)var1_1, (boolean)var2_2));
    }

    public String encodeUtf8() {
        return this.encodeCharset(StandardCharsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public String encodeCharset(Charset charset) {
        void var1_1;
        return new String(this.byteArray, (Charset)Objects.requireNonNull(var1_1, "given charset must not be null"));
    }

    public byte[] encodeUtf8ToBytes() {
        return this.encodeCharsetToBytes(StandardCharsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] encodeCharsetToBytes(Charset charset) {
        void var1_1;
        return this.encodeCharset(charset).getBytes((Charset)var1_1);
    }

    public String encode(BinaryToTextEncoding.Encoder encoder) {
        return encoder.encode(this.byteArray, this.byteOrder);
    }

    public List<Byte> toList() {
        byte[] byArray = this.byteArray;
        ArrayList<Byte> arrayList = new ArrayList<Byte>(byArray.length);
        for (byte by : byArray) {
            arrayList.add(by);
        }
        return arrayList;
    }

    public Byte[] toBoxedArray() {
        byte[] byArray = this.byteArray;
        Byte[] byteArray = new Byte[this.byteArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byteArray[i] = byArray[i];
        }
        return byteArray;
    }

    public BitSet toBitSet() {
        return BitSet.valueOf(this.byteArray);
    }

    public BigInteger toBigInteger() {
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return new BigInteger(new BytesTransformer.ReverseTransformer().transform(this.byteArray, false));
        }
        return new BigInteger(this.byteArray);
    }

    /*
     * WARNING - void declaration
     */
    public UUID toUUID() {
        void var1_1;
        if (this.length() != 16) {
            throw new IllegalStateException("creating UUID requires internal array to be exactly 16 bytes, was " + this.length());
        }
        ByteBuffer byteBuffer = this.buffer();
        return new UUID(byteBuffer.getLong(), var1_1.getLong());
    }

    public byte toByte() {
        Util.Validation.checkExactLength(this.length(), 1, "byte");
        return this.byteArray[0];
    }

    public int toUnsignedByte() {
        Util.Validation.checkExactLength(this.length(), 1, "unsigned byte");
        return this.unsignedByteAt(0);
    }

    public char toChar() {
        Util.Validation.checkExactLength(this.length(), 2, "char");
        return this.charAt(0);
    }

    public short toShort() {
        Util.Validation.checkExactLength(this.length(), 2, "short");
        return this.shortAt(0);
    }

    public int toInt() {
        Util.Validation.checkExactLength(this.length(), 4, "int");
        return this.intAt(0);
    }

    public int[] toIntArray() {
        Util.Validation.checkModLength(this.length(), 4, "creating an int array");
        Object object = this.byteOrder;
        IntBuffer intBuffer = ByteBuffer.wrap(this.byteArray).order((ByteOrder)object).asIntBuffer();
        object = new int[intBuffer.remaining()];
        intBuffer.get((int[])object);
        return object;
    }

    public long toLong() {
        Util.Validation.checkExactLength(this.length(), 8, "long");
        return this.longAt(0);
    }

    public long[] toLongArray() {
        Util.Validation.checkModLength(this.length(), 8, "creating an long array");
        Object object = this.byteOrder;
        LongBuffer longBuffer = ByteBuffer.wrap(this.byteArray).order((ByteOrder)object).asLongBuffer();
        object = new long[longBuffer.remaining()];
        longBuffer.get((long[])object);
        return object;
    }

    public float toFloat() {
        Util.Validation.checkExactLength(this.length(), 4, "float");
        return this.internalBuffer().getFloat();
    }

    public float[] toFloatArray() {
        Util.Validation.checkModLength(this.length(), 4, "creating an float array");
        Object object = this.byteOrder;
        FloatBuffer floatBuffer = ByteBuffer.wrap(this.byteArray).order((ByteOrder)object).asFloatBuffer();
        object = new float[floatBuffer.remaining()];
        floatBuffer.get((float[])object);
        return object;
    }

    public double toDouble() {
        Util.Validation.checkExactLength(this.length(), 8, "double");
        return this.internalBuffer().getDouble();
    }

    public double[] toDoubleArray() {
        Util.Validation.checkModLength(this.length(), 8, "creating an double array");
        Object object = this.byteOrder;
        DoubleBuffer doubleBuffer = ByteBuffer.wrap(this.byteArray).order((ByteOrder)object).asDoubleBuffer();
        object = new double[doubleBuffer.remaining()];
        doubleBuffer.get((double[])object);
        return object;
    }

    public char[] toCharArray() {
        return this.toCharArray(StandardCharsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public char[] toCharArray(Charset charset) {
        void var1_1;
        return Util.Converter.byteToCharArray(this.byteArray, (Charset)var1_1, this.byteOrder);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(Bytes o) {
        void var1_1;
        return this.internalBuffer().compareTo(super.internalBuffer());
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bytes bytes = (Bytes)o;
        if (!Arrays.equals(this.byteArray, bytes.byteArray)) {
            return false;
        }
        return Objects.equals(this.byteOrder, var1_1.byteOrder);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(byte[] anotherArray) {
        void var1_1;
        return anotherArray != null && Arrays.equals(this.byteArray, (byte[])var1_1);
    }

    public boolean equalsConstantTime(byte[] anotherArray) {
        if (anotherArray != null) {
            boolean bl;
            byte[] byArray;
            void var2_2 = byArray;
            byArray = this.byteArray;
            if (var2_2 == null || byArray.length != ((void)var2_2).length) {
                bl = false;
            } else {
                int n = 0;
                for (int i = 0; i < byArray.length; ++i) {
                    n |= byArray[i] ^ var2_2[i];
                }
                bl = n == 0;
            }
            if (bl) {
                return true;
            }
        }
        return false;
    }

    public boolean equals(Byte[] anotherArray) {
        byte[] byArray;
        void var2_2 = byArray;
        byArray = this.byteArray;
        if (var2_2 == null) {
            return false;
        }
        if (byArray.length != ((void)var2_2).length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (var2_2[i] != null && byArray[i] == var2_2[i].byteValue()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(ByteBuffer buffer) {
        void var1_1;
        return buffer != null && this.byteOrder == buffer.order() && this.internalBuffer().equals(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equalsContent(Bytes other) {
        void var1_1;
        return other != null && Arrays.equals(this.byteArray, var1_1.byteArray);
    }

    public int hashCode() {
        if (this.hashCodeCache == 0) {
            this.hashCodeCache = Util.Obj.hashCode(this.byteArray, this.byteOrder());
        }
        return this.hashCodeCache;
    }

    public String toString() {
        String string;
        Bytes bytes = this;
        if (bytes.isEmpty()) {
            string = "";
        } else if (bytes.length() > 8) {
            Bytes bytes2 = bytes;
            string = "(0x" + bytes.copy(0, 4).encodeHex() + "..." + bytes2.copy(bytes2.length() - 4, 4).encodeHex() + ")";
        } else {
            string = "(0x" + bytes.encodeHex() + ")";
        }
        return bytes.length() + " " + (bytes.length() == 1 ? "byte" : "bytes") + " " + string;
    }

    @Override
    public Iterator<Byte> iterator() {
        return new Util.BytesIterator(this.byteArray);
    }

    private static final class Factory
    implements BytesFactory {
        private Factory() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Bytes wrap(byte[] array, ByteOrder byteOrder) {
            void var2_2;
            void var1_1;
            return new Bytes((byte[])var1_1, (ByteOrder)var2_2);
        }

        /* synthetic */ Factory(byte by) {
            this();
        }
    }
}

