/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.bytes;

import at.favre.lib.bytes.Base64;
import at.favre.lib.bytes.Bytes;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public interface BinaryToTextEncoding {

    public static class BaseRadixNumber
    implements EncoderDecoder {
        private final int radix;

        /*
         * WARNING - void declaration
         */
        BaseRadixNumber(int radix) {
            void var1_1;
            if (radix < 2 || radix > 36) {
                throw new IllegalArgumentException("supported radix is between 2 and 36");
            }
            this.radix = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String encode(byte[] array, ByteOrder byteOrder) {
            void var1_1;
            void var2_2;
            return new BigInteger(1, var2_2 == ByteOrder.BIG_ENDIAN ? array : Bytes.from((byte[])var1_1).reverse().array()).toString(this.radix);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public byte[] decode(CharSequence encoded) {
            void var1_1;
            byte[] array = new BigInteger(encoded.toString(), this.radix).toByteArray();
            if (array[0] == 0) {
                void var2_2;
                byte[] tmp = new byte[array.length - 1];
                System.arraycopy(array, 1, tmp, 0, tmp.length);
                array = var2_2;
            }
            return var1_1;
        }
    }

    public static class Base64Encoding
    implements EncoderDecoder {
        private final boolean urlSafe;
        private final boolean padding;

        Base64Encoding() {
            this(false, true);
        }

        /*
         * WARNING - void declaration
         */
        Base64Encoding(boolean urlSafe, boolean padding) {
            void var2_2;
            void var1_1;
            this.urlSafe = var1_1;
            this.padding = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String encode(byte[] array, ByteOrder byteOrder) {
            void var1_1;
            void var2_2;
            return new String(Base64.encode(var2_2 == ByteOrder.BIG_ENDIAN ? array : Bytes.from((byte[])var1_1).reverse().array(), this.urlSafe, this.padding), StandardCharsets.US_ASCII);
        }

        @Override
        public byte[] decode(CharSequence encoded) {
            return Base64.decode(encoded);
        }
    }

    public static class Hex
    implements EncoderDecoder {
        private final boolean upperCase;

        public Hex() {
            this(true);
        }

        /*
         * WARNING - void declaration
         */
        public Hex(boolean upperCase) {
            void var1_1;
            this.upperCase = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String encode(byte[] byteArray, ByteOrder byteOrder) {
            void var3_3;
            StringBuilder sb = new StringBuilder(byteArray.length * 2);
            for (int i = 0; i < byteArray.length; ++i) {
                int index = byteOrder == ByteOrder.BIG_ENDIAN ? i : byteArray.length - i - 1;
                char first4Bit = Character.forDigit(byteArray[index] >> 4 & 0xF, 16);
                char last4Bit = Character.forDigit(byteArray[index] & 0xF, 16);
                if (this.upperCase) {
                    first4Bit = Character.toUpperCase(first4Bit);
                    last4Bit = Character.toUpperCase(last4Bit);
                }
                sb.append(first4Bit).append(last4Bit);
            }
            return var3_3.toString();
        }

        @Override
        public byte[] decode(CharSequence hexString) {
            int start = Objects.requireNonNull(hexString).length() > 2 && hexString.charAt(0) == '0' && hexString.charAt(1) == 'x' ? 2 : 0;
            int len = hexString.length();
            boolean isOddLength = len % 2 != 0;
            if (isOddLength) {
                --start;
            }
            byte[] data = new byte[(len - start) / 2];
            for (int i = start; i < len; i += 2) {
                int first4Bits = i == start && isOddLength ? 0 : Character.digit(hexString.charAt(i), 16);
                int second4Bits = Character.digit(hexString.charAt(i + 1), 16);
                if (first4Bits == -1 || second4Bits == -1) {
                    if (i == start && isOddLength) {
                        throw new IllegalArgumentException("'" + hexString.charAt(i + 1) + "' at index " + (i + 1) + " is not hex formatted");
                    }
                    throw new IllegalArgumentException("'" + hexString.charAt(i) + hexString.charAt(i + 1) + "' at index " + i + " is not hex formatted");
                }
                data[(i - start) / 2] = (byte)((first4Bits << 4) + second4Bits);
            }
            return data;
        }
    }

    public static interface EncoderDecoder
    extends Decoder,
    Encoder {
    }

    public static interface Decoder {
        public byte[] decode(CharSequence var1);
    }

    public static interface Encoder {
        public String encode(byte[] var1, ByteOrder var2);
    }
}

