/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.bytes;

import at.favre.lib.bytes.Bytes;
import at.favre.lib.bytes.BytesFactory;
import at.favre.lib.bytes.Util;
import java.nio.ByteOrder;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Objects;

public final class MutableBytes
extends Bytes {
    MutableBytes(byte[] byteArray, ByteOrder byteOrder) {
        super(byteArray, byteOrder, new Factory());
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    public MutableBytes overwrite(byte[] newArray) {
        this.overwrite(newArray, 0);
        return this;
    }

    public MutableBytes overwrite(byte[] newArray, int offsetInternalArray) {
        Objects.requireNonNull(newArray, "must provide non-null array as source");
        System.arraycopy(newArray, 0, this.internalArray(), offsetInternalArray, newArray.length);
        return this;
    }

    public MutableBytes setByteAt(int index, byte newByte) {
        this.internalArray()[index] = newByte;
        return this;
    }

    public MutableBytes wipe() {
        this.fill((byte)0);
        return this;
    }

    public MutableBytes fill(byte fillByte) {
        Arrays.fill(this.internalArray(), fillByte);
        return this;
    }

    public MutableBytes secureWipe() {
        this.secureWipe(new SecureRandom());
        return this;
    }

    public MutableBytes secureWipe(SecureRandom random) {
        Objects.requireNonNull(random, "must be non-null random");
        if (this.length() > 0) {
            random.nextBytes(this.internalArray());
        }
        return this;
    }

    public Bytes immutable() {
        return Bytes.wrap(this.internalArray(), this.byteOrder());
    }

    @Override
    public int hashCode() {
        return Util.hashCode(this.internalArray(), this.byteOrder());
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    private static class Factory
    implements BytesFactory {
        private Factory() {
        }

        @Override
        public Bytes wrap(byte[] array, ByteOrder byteOrder) {
            return new MutableBytes(array, byteOrder);
        }
    }
}

