/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.bytes;

import java.util.List;

public interface BytesValidator {
    public boolean validate(byte[] var1);

    public static final class Logical
    implements BytesValidator {
        private final List<BytesValidator> validatorList;
        private final Operator operator;

        /*
         * WARNING - void declaration
         */
        public Logical(List<BytesValidator> validatorList, Operator operator) {
            void var2_2;
            void var1_1;
            if (validatorList.isEmpty()) {
                throw new IllegalArgumentException("must contain at least 1 element");
            }
            if (operator == Operator.NOT && validatorList.size() != 1) {
                throw new IllegalArgumentException("not operator can only be applied to single element");
            }
            this.validatorList = var1_1;
            this.operator = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean validate(byte[] byteArrayToValidate) {
            void var2_2;
            if (this.operator == Operator.NOT) {
                return !this.validatorList.get(0).validate(byteArrayToValidate);
            }
            boolean bool = this.operator != Operator.OR;
            block3: for (BytesValidator bytesValidator : this.validatorList) {
                switch (this.operator) {
                    case AND: {
                        bool &= bytesValidator.validate(byteArrayToValidate);
                        continue block3;
                    }
                }
                bool |= bytesValidator.validate(byteArrayToValidate);
            }
            return (boolean)var2_2;
        }

        static enum Operator {
            OR,
            AND,
            NOT;

        }
    }

    public static final class PrePostFix
    implements BytesValidator {
        private final byte[] pfix;
        private final boolean startsWith;

        /*
         * WARNING - void declaration
         */
        public PrePostFix(boolean startsWith, byte ... pfix) {
            void var1_1;
            void var2_2;
            this.pfix = var2_2;
            this.startsWith = var1_1;
        }

        @Override
        public final boolean validate(byte[] byteArrayToValidate) {
            if (this.pfix.length > byteArrayToValidate.length) {
                return false;
            }
            for (int i = 0; i < this.pfix.length; ++i) {
                if (this.startsWith && this.pfix[i] != byteArrayToValidate[i]) {
                    return false;
                }
                if (this.startsWith || this.pfix[i] == byteArrayToValidate[byteArrayToValidate.length - this.pfix.length + i]) continue;
                return false;
            }
            return true;
        }
    }

    public static final class IdenticalContent
    implements BytesValidator {
        private final byte refByte;
        private final int mode$62bc4116;

        /*
         * WARNING - void declaration
         */
        IdenticalContent(byte refByte, int mode) {
            void var2_2;
            void var1_1;
            this.refByte = var1_1;
            this.mode$62bc4116 = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean validate(byte[] byteArrayToValidate) {
            int n = byteArrayToValidate.length;
            for (int i = 0; i < n; ++i) {
                void var1_1;
                void b = var1_1[i];
                if (this.mode$62bc4116 == Mode.NONE_OF$62bc4116 && b == this.refByte) {
                    return false;
                }
                if (this.mode$62bc4116 == Mode.ONLY_OF$62bc4116 && b != this.refByte) {
                    return false;
                }
                if (this.mode$62bc4116 != Mode.NOT_ONLY_OF$62bc4116 || b == this.refByte) continue;
                return true;
            }
            return this.mode$62bc4116 == Mode.NONE_OF$62bc4116 || this.mode$62bc4116 == Mode.ONLY_OF$62bc4116;
        }

        static final class Mode
        extends Enum<Mode> {
            public static final int ONLY_OF$62bc4116 = 1;
            public static final int NONE_OF$62bc4116 = 2;
            public static final int NOT_ONLY_OF$62bc4116 = 3;
            private static final /* synthetic */ int[] $VALUES$7b03791b;

            static {
                $VALUES$7b03791b = new int[]{ONLY_OF$62bc4116, NONE_OF$62bc4116, NOT_ONLY_OF$62bc4116};
            }
        }
    }

    public static final class Length
    implements BytesValidator {
        private final int refLength;
        private final Mode mode;

        /*
         * WARNING - void declaration
         */
        public Length(int refLength, Mode mode) {
            void var2_2;
            void var1_1;
            this.refLength = var1_1;
            this.mode = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean validate(byte[] byteArrayToValidate) {
            void var1_1;
            switch (this.mode) {
                case GREATER_OR_EQ_THAN: {
                    return byteArrayToValidate.length >= this.refLength;
                }
                case SMALLER_OR_EQ_THAN: {
                    return byteArrayToValidate.length <= this.refLength;
                }
            }
            return ((void)var1_1).length == this.refLength;
        }

        static enum Mode {
            SMALLER_OR_EQ_THAN,
            GREATER_OR_EQ_THAN,
            EXACT;

        }
    }
}

