/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.bytes;

import at.favre.lib.bytes.Bytes;
import at.favre.lib.bytes.BytesTransformer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Random;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class BytesTransformers {
    private BytesTransformers() {
    }

    public static BytesTransformer shuffle() {
        return new ShuffleTransformer(new SecureRandom());
    }

    public static BytesTransformer shuffle(Random random) {
        Random random2;
        return new ShuffleTransformer(random2);
    }

    public static BytesTransformer sort() {
        return new SortTransformer();
    }

    public static BytesTransformer sortUnsigned() {
        return new SortTransformer(new SortTransformer.UnsignedByteComparator());
    }

    public static BytesTransformer sort(Comparator<Byte> comparator) {
        Comparator<Byte> comparator2;
        return new SortTransformer(comparator2);
    }

    public static BytesTransformer checksumAppendCrc32() {
        return new ChecksumTransformer(new CRC32(), ChecksumTransformer.Mode.APPEND, 4);
    }

    public static BytesTransformer checksumCrc32() {
        return new ChecksumTransformer(new CRC32(), ChecksumTransformer.Mode.TRANSFORM, 4);
    }

    /*
     * WARNING - void declaration
     */
    public static BytesTransformer checksum(Checksum checksum, ChecksumTransformer.Mode mode, int checksumLengthByte) {
        void var2_2;
        void var1_1;
        Checksum checksum2;
        return new ChecksumTransformer(checksum2, (ChecksumTransformer.Mode)var1_1, (int)var2_2);
    }

    public static BytesTransformer compressGzip() {
        return new GzipCompressor(true);
    }

    public static BytesTransformer decompressGzip() {
        return new GzipCompressor(false);
    }

    public static BytesTransformer hmacSha1(byte[] key) {
        byte[] byArray;
        return new HmacTransformer(byArray, "HmacSHA1");
    }

    public static BytesTransformer hmacSha256(byte[] key) {
        byte[] byArray;
        return new HmacTransformer(byArray, "HmacSHA256");
    }

    /*
     * WARNING - void declaration
     */
    public static BytesTransformer hmac(byte[] key, String algorithmName) {
        void var1_1;
        byte[] byArray;
        return new HmacTransformer(byArray, (String)var1_1);
    }

    public static final class HmacTransformer
    implements BytesTransformer {
        private final byte[] secretKey;
        private final String macAlgorithmName;

        /*
         * WARNING - void declaration
         */
        HmacTransformer(byte[] secretKey, String macAlgorithmName) {
            void var1_1;
            void var2_2;
            this.macAlgorithmName = var2_2;
            this.secretKey = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte[] transform(byte[] currentArray, boolean inPlace) {
            try {
                void var1_1;
                Mac mac = Mac.getInstance(this.macAlgorithmName);
                mac.init(new SecretKeySpec(this.secretKey, this.macAlgorithmName));
                return mac.doFinal((byte[])var1_1);
            }
            catch (Exception e) {
                void var2_4;
                throw new IllegalArgumentException((Throwable)var2_4);
            }
        }

        @Override
        public final boolean supportInPlaceTransformation() {
            return false;
        }
    }

    public static final class GzipCompressor
    implements BytesTransformer {
        private final boolean compress;

        /*
         * WARNING - void declaration
         */
        GzipCompressor(boolean compress) {
            void var1_1;
            this.compress = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte[] transform(byte[] currentArray, boolean inPlace) {
            void var1_1;
            if (this.compress) {
                return GzipCompressor.compress(currentArray);
            }
            return GzipCompressor.decompress((byte[])var1_1);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static byte[] decompress(byte[] compressedContent) {
            byte[] returnBuffer;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            GZIPInputStream gzipInputStream = null;
            try {
                int len;
                byte[] buffer = new byte[4096];
                gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(compressedContent));
                while ((len = gzipInputStream.read(buffer)) > 0) {
                    bos.write(buffer, 0, len);
                }
                gzipInputStream.close();
                returnBuffer = bos.toByteArray();
                bos.close();
            }
            catch (Exception e) {
                try {
                    void var0_3;
                    throw new IllegalStateException("could not decompress gzip", (Throwable)var0_3);
                }
                catch (Throwable throwable) {
                    try {
                        void var1_5;
                        var1_5.close();
                    }
                    catch (IOException iOException) {}
                    if (gzipInputStream == null) throw throwable;
                    try {
                        void var2_6;
                        var2_6.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                bos.close();
            }
            catch (IOException iOException) {}
            try {
                gzipInputStream.close();
                return returnBuffer;
            }
            catch (IOException iOException) {}
            return returnBuffer;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static byte[] compress(byte[] content) {
            byte[] returnBuffer;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(content.length);
            GZIPOutputStream gzipOutputStream = null;
            try {
                gzipOutputStream = new GZIPOutputStream(bos);
                gzipOutputStream.write(content);
                gzipOutputStream.close();
                returnBuffer = bos.toByteArray();
                bos.close();
            }
            catch (Exception e) {
                try {
                    void var0_1;
                    throw new IllegalStateException("could not compress gzip", (Throwable)var0_1);
                }
                catch (Throwable throwable) {
                    try {
                        void var1_3;
                        var1_3.close();
                    }
                    catch (IOException iOException) {}
                    if (gzipOutputStream == null) throw throwable;
                    try {
                        void var2_4;
                        var2_4.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                bos.close();
            }
            catch (IOException iOException) {}
            try {
                gzipOutputStream.close();
                return returnBuffer;
            }
            catch (IOException iOException) {}
            return returnBuffer;
        }

        @Override
        public final boolean supportInPlaceTransformation() {
            return false;
        }
    }

    public static final class ChecksumTransformer
    implements BytesTransformer {
        private final Checksum checksum;
        private final Mode mode;
        private final int checksumLengthByte;

        /*
         * WARNING - void declaration
         */
        ChecksumTransformer(Checksum checksum, Mode mode, int checksumLengthByte) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (checksumLengthByte <= 0 || checksumLengthByte > 8) {
                throw new IllegalArgumentException("checksumlength must be between 1 and 8 bytes");
            }
            Objects.requireNonNull(checksum, "checksum instance must not be null");
            this.checksum = var1_1;
            this.mode = var2_2;
            this.checksumLengthByte = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte[] transform(byte[] currentArray, boolean inPlace) {
            void var2_3;
            void var1_1;
            this.checksum.update(currentArray, 0, currentArray.length);
            byte[] checksumBytes = Bytes.from(this.checksum.getValue()).resize(this.checksumLengthByte).array();
            if (this.mode == Mode.TRANSFORM) {
                return checksumBytes;
            }
            return Bytes.from(new byte[][]{var1_1, var2_3}).array();
        }

        @Override
        public final boolean supportInPlaceTransformation() {
            return false;
        }

        public static enum Mode {
            APPEND,
            TRANSFORM;

        }
    }

    public static final class SortTransformer
    implements BytesTransformer {
        private final Comparator comparator;

        SortTransformer() {
            this(null);
        }

        /*
         * WARNING - void declaration
         */
        SortTransformer(Comparator<Byte> comparator) {
            void var1_1;
            this.comparator = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte[] transform(byte[] currentArray, boolean inPlace) {
            void var1_1;
            byte[] out;
            if (this.comparator == null) {
                void var2_2;
                out = var2_2 != false ? currentArray : Bytes.from(currentArray).array();
                Arrays.sort(out);
                return out;
            }
            Byte[] boxedArray = Bytes.wrap(out).toBoxedArray();
            Arrays.sort(boxedArray, this.comparator);
            return Bytes.from((Byte[])var1_1).array();
        }

        @Override
        public final boolean supportInPlaceTransformation() {
            return this.comparator == null;
        }

        static final class UnsignedByteComparator
        implements Comparator<Byte> {
            UnsignedByteComparator() {
            }
        }
    }

    public static final class ShuffleTransformer
    implements BytesTransformer {
        private final Random random;

        /*
         * WARNING - void declaration
         */
        ShuffleTransformer(Random random) {
            void var1_1;
            Objects.requireNonNull(random, "passed random must not be null");
            this.random = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte[] transform(byte[] currentArray, boolean inPlace) {
            void var1_1;
            byte[] out = inPlace ? currentArray : Bytes.from(currentArray).array();
            Random random = this.random;
            byte[] byArray = out;
            for (int i = out.length - 1; i > 0; --i) {
                int n = random.nextInt(i + 1);
                byte by = byArray[n];
                byArray[n] = byArray[i];
                byArray[i] = by;
            }
            return var1_1;
        }

        @Override
        public final boolean supportInPlaceTransformation() {
            return true;
        }
    }
}

