/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.bytes;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

final class Util {
    /*
     * WARNING - void declaration
     */
    static byte[] concat(byte[] ... arrays) {
        byte[][] byArray;
        int length = 0;
        byte[][] byArray2 = arrays;
        int n = arrays.length;
        for (int i = 0; i < n; ++i) {
            byte[] array = byArray2[i];
            length += array.length;
        }
        byte[] result = new byte[length];
        int pos = 0;
        byte[][] byArray3 = byArray;
        int n2 = byArray.length;
        for (int i = 0; i < n2; ++i) {
            void var1_3;
            byte[] array = byArray3[i];
            System.arraycopy(array, 0, result, pos, array.length);
            pos += ((void)var1_3).length;
        }
        return byArray2;
    }

    /*
     * WARNING - void declaration
     */
    static byte[] readFromStream(InputStream inputStream) {
        try {
            int r;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            while ((r = inputStream.read(buf)) != -1) {
                void var3_4;
                out.write(buf, 0, (int)var3_4);
            }
            return out.toByteArray();
        }
        catch (Exception e) {
            void var1_2;
            throw new IllegalStateException("could not read from input stream", (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    static byte[] readFromDataInput(DataInput dataInput, int length) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            void var2_2;
            int remaining = length;
            for (int i = 0; i < length; ++i) {
                byte[] buf = new byte[Math.min(remaining, 4096)];
                dataInput.readFully(buf);
                out.write(buf);
                remaining -= buf.length;
            }
            return var2_2.toByteArray();
        }
        catch (Exception e) {
            void var3_6;
            throw new IllegalStateException("could not read from data input", (Throwable)var3_6);
        }
    }

    /*
     * WARNING - void declaration
     */
    static byte[] readFromFile(File file) {
        if (file == null || !file.exists() || !file.isFile()) {
            throw new IllegalArgumentException("file must not be null, has to exist and must be a file (not a directory) ".concat(String.valueOf(file)));
        }
        try {
            return Files.readAllBytes(file.toPath());
        }
        catch (IOException e) {
            void var0_1;
            throw new IllegalStateException("could not read from file", (Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    static void checkIndexBounds(int length, int index, int primitiveLength, String type) {
        int n;
        void var2_2;
        if (index < 0 || index + var2_2 > n) {
            void var1_1;
            void var3_3;
            throw new IndexOutOfBoundsException("cannot get " + (String)var3_3 + " from index out of bounds: " + (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    static void checkExactLength(int length, int expectedLength, String type) {
        if (length != expectedLength) {
            int n;
            void var1_1;
            void var2_2;
            throw new IllegalStateException("cannot convert to " + (String)var2_2 + " if length != " + (int)var1_1 + " bytes (was " + n + ")");
        }
    }

    static final class BytesIterator
    implements Iterator<Byte> {
        private final byte[] array;
        private int cursor = 0;

        /*
         * WARNING - void declaration
         */
        BytesIterator(byte[] array) {
            void var1_1;
            this.array = var1_1;
        }

        @Override
        public final boolean hasNext() {
            return this.cursor != this.array.length;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        private Byte next() {
            try {
                void var2_2;
                void var1_1;
                int i = this.cursor;
                Byte next = this.array[i];
                this.cursor = var1_1 + true;
                return var2_2;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("The Bytes iterator does not support removing");
        }
    }

    static final class Entropy<T> {
        private final Map<T, Integer> map = new HashMap<T, Integer>();
        private int total = 0;

        /*
         * WARNING - void declaration
         */
        public Entropy(Iterable<T> elements) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                Object element = iterator.next();
                if (!this.map.containsKey(element)) {
                    this.map.put(element, 0);
                }
                this.map.put(element, this.map.get(var2_2) + 1);
                ++this.total;
            }
        }

        /*
         * WARNING - void declaration
         */
        public final double entropy() {
            void var1_1;
            double entropy = 0.0;
            Iterator<Integer> iterator = this.map.values().iterator();
            while (iterator.hasNext()) {
                double prob;
                double d = prob = (double)iterator.next().intValue() / (double)this.total;
                entropy -= d * (Math.log(d) / Math.log(2.0));
            }
            return (double)var1_1;
        }
    }
}

