/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.bytes;

import at.favre.lib.bytes.BinaryToTextEncoding;
import at.favre.lib.bytes.BytesFactory;
import at.favre.lib.bytes.BytesTransformer;
import at.favre.lib.bytes.BytesValidator;
import at.favre.lib.bytes.BytesValidators;
import at.favre.lib.bytes.MutableBytes;
import at.favre.lib.bytes.ReadOnlyBytes;
import at.favre.lib.bytes.Util;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;

public class Bytes
implements Serializable,
Comparable<Bytes>,
Iterable<Byte> {
    private final byte[] byteArray;
    private final ByteOrder byteOrder;
    private final BytesFactory factory;

    public static Bytes allocate(int length) {
        return Bytes.allocate(length, (byte)0);
    }

    /*
     * WARNING - void declaration
     */
    public static Bytes allocate(int length, byte defaultValue) {
        void var2_2;
        int n;
        byte[] array = new byte[length];
        if (defaultValue != 0 && n > 0) {
            void var1_1;
            Arrays.fill(array, (byte)var1_1);
        }
        return Bytes.wrap((byte[])var2_2);
    }

    public static Bytes empty() {
        return Bytes.allocate(0);
    }

    public static Bytes wrap(Bytes bytes) {
        Bytes bytes2;
        return new Bytes(bytes.byteArray, bytes2.byteOrder);
    }

    public static Bytes wrapNullSafe(byte[] array) {
        byte[] byArray;
        return Bytes.wrap(array != null ? byArray : new byte[]{});
    }

    public static Bytes wrap(byte[] array) {
        return Bytes.wrap(array, ByteOrder.BIG_ENDIAN);
    }

    /*
     * WARNING - void declaration
     */
    public static Bytes wrap(byte[] array, ByteOrder byteOrder) {
        void var1_1;
        byte[] byArray;
        Objects.requireNonNull(array, "passed array must not be null");
        return new Bytes(byArray, (ByteOrder)var1_1);
    }

    public static Bytes from(byte[] byteArrayToCopy) {
        byte[] byArray;
        Objects.requireNonNull(byteArrayToCopy, "must at least pass a single byte");
        return Bytes.wrap(Arrays.copyOf(byArray, byArray.length));
    }

    public static Bytes fromNullSafe(byte[] byteArrayToCopy) {
        byte[] byArray;
        return Bytes.from(byteArrayToCopy != null ? byArray : new byte[]{});
    }

    /*
     * WARNING - void declaration
     */
    public static Bytes from(byte[] array, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        byte[] byArray;
        Objects.requireNonNull(array, "passed array must not be null");
        byte[] part = new byte[length];
        System.arraycopy(byArray, (int)var1_1, part, 0, (int)var2_2);
        return Bytes.wrap((byte[])var3_3);
    }

    public static Bytes from(byte[] ... moreArrays) {
        return Bytes.wrap(Util.concat(moreArrays));
    }

    /*
     * WARNING - void declaration
     */
    public static Bytes from(Bytes ... moreBytes) {
        void var1_1;
        Objects.requireNonNull(moreBytes, "bytes most not be null");
        byte[][] bytes = new byte[moreBytes.length][];
        for (int i = 0; i < moreBytes.length; ++i) {
            bytes[i] = moreBytes[i].array();
        }
        return Bytes.from((byte[][])var1_1);
    }

    public static Bytes from(Collection<Byte> bytesCollection) {
        Object[] objectArray = bytesCollection.toArray();
        int n = objectArray.length;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (Byte)objectArray[i];
        }
        return Bytes.wrap(byArray);
    }

    public static Bytes from(Byte[] boxedObjectArray) {
        Byte[] byteArray;
        byte[] byArray = new byte[boxedObjectArray.length];
        for (int i = 0; i < byteArray.length; ++i) {
            byArray[i] = byteArray[i];
        }
        return Bytes.wrap(byArray);
    }

    public static Bytes from(byte singleByte) {
        byte by;
        return Bytes.wrap(new byte[]{by});
    }

    /*
     * WARNING - void declaration
     */
    public static Bytes from(byte firstByte, byte ... moreBytes) {
        byte by;
        byte[] byArray;
        if (moreBytes == null) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = by;
        } else {
            void var1_1;
            byArray = Util.concat(new byte[][]{{by}, var1_1});
        }
        return Bytes.wrap(byArray);
    }

    public static Bytes from(boolean booleanValue) {
        boolean bl;
        return Bytes.wrap(new byte[]{bl ? (byte)1 : 0});
    }

    public static Bytes from(char char2Byte) {
        char c;
        return Bytes.wrap(ByteBuffer.allocate(2).putChar(c).array());
    }

    public static Bytes from(short short2Byte) {
        short s;
        return Bytes.wrap(ByteBuffer.allocate(2).putShort(s).array());
    }

    public static Bytes from(int integer4byte) {
        int n;
        return Bytes.wrap(ByteBuffer.allocate(4).putInt(n).array());
    }

    public static Bytes from(int ... intArray) {
        int[] nArray;
        Objects.requireNonNull(intArray, "must provide at least a single int");
        byte[] byArray = new byte[nArray.length * 4];
        for (int i = 0; i < nArray.length; ++i) {
            byte[] byArray2 = ByteBuffer.allocate(4).putInt(nArray[i]).array();
            System.arraycopy(byArray2, 0, byArray, i * 4, byArray2.length);
        }
        return Bytes.wrap(byArray);
    }

    public static Bytes from(long long8byte) {
        long l;
        return Bytes.wrap(ByteBuffer.allocate(8).putLong(l).array());
    }

    public static Bytes from(long ... longArray) {
        long[] lArray;
        Objects.requireNonNull(longArray, "must provide at least a single long");
        byte[] byArray = new byte[lArray.length * 8];
        for (int i = 0; i < lArray.length; ++i) {
            byte[] byArray2 = ByteBuffer.allocate(8).putLong(lArray[i]).array();
            System.arraycopy(byArray2, 0, byArray, i * 8, byArray2.length);
        }
        return Bytes.wrap(byArray);
    }

    public static Bytes from(float float4byte) {
        float f;
        return Bytes.wrap(ByteBuffer.allocate(4).putFloat(f).array());
    }

    public static Bytes from(double double8Byte) {
        double d;
        return Bytes.wrap(ByteBuffer.allocate(8).putDouble(d).array());
    }

    public static Bytes from(ByteBuffer buffer) {
        ByteBuffer byteBuffer;
        return Bytes.wrap(buffer.array(), byteBuffer.order());
    }

    public static Bytes from(BitSet set) {
        return Bytes.wrap(set.toByteArray());
    }

    public static Bytes from(BigInteger bigInteger) {
        return Bytes.wrap(bigInteger.toByteArray());
    }

    public static Bytes from(InputStream stream) {
        return Bytes.wrap(Util.readFromStream(stream));
    }

    /*
     * WARNING - void declaration
     */
    public static Bytes from(DataInput dataInput, int length) {
        void var1_1;
        return Bytes.wrap(Util.readFromDataInput(dataInput, (int)var1_1));
    }

    public static Bytes from(File file) {
        return Bytes.wrap(Util.readFromFile(file));
    }

    public static Bytes from(CharSequence utf8String) {
        return Bytes.from(utf8String, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public static Bytes from(CharSequence utf8String, Normalizer.Form form) {
        void var1_1;
        return Bytes.from((CharSequence)Normalizer.normalize(utf8String, (Normalizer.Form)var1_1), StandardCharsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public static Bytes from(CharSequence string, Charset charset) {
        void var1_1;
        CharSequence charSequence;
        Objects.requireNonNull(string, "provided string must not be null");
        Objects.requireNonNull(charset, "provided charset must not be null");
        return Bytes.wrap(charSequence.toString().getBytes((Charset)var1_1));
    }

    public static Bytes from(char[] charArray) {
        return Bytes.from(charArray, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public static Bytes from(char[] charArray, Charset charset) {
        void var1_1;
        Object object;
        ByteBuffer byteBuffer = charset.encode(CharBuffer.wrap(charArray));
        Object bb = byteBuffer;
        byte[] bytes = new byte[byteBuffer.remaining()];
        ((ByteBuffer)object).get(bytes);
        return Bytes.from((byte[])var1_1);
    }

    public static Bytes from(UUID uuid) {
        UUID uUID;
        Objects.requireNonNull(uuid);
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        byteBuffer.putLong(uUID.getMostSignificantBits());
        byteBuffer.putLong(uUID.getLeastSignificantBits());
        return Bytes.wrap(byteBuffer.array());
    }

    public static Bytes parseBinary(String binaryString) {
        return Bytes.parse(binaryString, new BinaryToTextEncoding.BaseRadix(2));
    }

    public static Bytes parseOctal(String octalString) {
        return Bytes.parse(octalString, new BinaryToTextEncoding.BaseRadix(8));
    }

    public static Bytes parseDec(String decString) {
        return Bytes.parse(decString, new BinaryToTextEncoding.BaseRadix(10));
    }

    public static Bytes parseHex(String hexString) {
        return Bytes.parse(hexString, new BinaryToTextEncoding.Hex());
    }

    public static Bytes parseBase36(String base36String) {
        return Bytes.parse(base36String, new BinaryToTextEncoding.BaseRadix(36));
    }

    public static Bytes parseBase64(String base64String) {
        return Bytes.parse(base64String, new BinaryToTextEncoding.Base64Encoding());
    }

    /*
     * WARNING - void declaration
     */
    public static Bytes parse(String encoded, BinaryToTextEncoding.Decoder decoder) {
        String string;
        void var1_1;
        Objects.requireNonNull(encoded, "encoded data must not be null");
        Objects.requireNonNull(decoder, "passed decoder instance must no be null");
        return Bytes.wrap(var1_1.decode(string));
    }

    public static Bytes random(int length) {
        return Bytes.random(length, new SecureRandom());
    }

    /*
     * WARNING - void declaration
     */
    public static Bytes random(int length, Random random) {
        void var0_1;
        void var1_2;
        byte[] array = new byte[length];
        var1_2.nextBytes(array);
        return Bytes.wrap((byte[])var0_1);
    }

    /*
     * WARNING - void declaration
     */
    Bytes(byte[] byteArray, ByteOrder byteOrder) {
        this((byte[])var1_1, (ByteOrder)var2_2, new Factory(0));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    Bytes(byte[] byteArray, ByteOrder byteOrder, BytesFactory factory) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.byteArray = var1_1;
        this.byteOrder = var2_2;
        this.factory = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Bytes append(Bytes bytes) {
        void var1_1;
        return this.append(var1_1.byteArray);
    }

    /*
     * WARNING - void declaration
     */
    public Bytes append(byte singleByte) {
        void var1_1;
        return this.append(Bytes.from((byte)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Bytes append(char char2Bytes) {
        void var1_1;
        return this.append(Bytes.from((char)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Bytes append(short short2Bytes) {
        void var1_1;
        return this.append(Bytes.from((short)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Bytes append(int integer4Bytes) {
        void var1_1;
        return this.append(Bytes.from((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Bytes append(long long8Bytes) {
        void var1_1;
        return this.append(Bytes.from((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Bytes append(byte[] secondArray) {
        void var1_1;
        return this.transform(new BytesTransformer.ConcatTransformer((byte[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Bytes appendNullSafe(byte[] secondArrayNullable) {
        void var1_1;
        if (secondArrayNullable == null) {
            return this;
        }
        return this.append((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Bytes append(CharSequence stringUtf8) {
        void var1_1;
        return this.append((CharSequence)var1_1, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public Bytes append(CharSequence string, Charset charset) {
        void var2_2;
        void var1_1;
        Objects.requireNonNull(charset);
        Objects.requireNonNull(string);
        return this.transform(new BytesTransformer.ConcatTransformer(var1_1.toString().getBytes((Charset)var2_2)));
    }

    /*
     * WARNING - void declaration
     */
    public Bytes xor(Bytes bytes) {
        void var1_1;
        return this.xor(var1_1.byteArray);
    }

    /*
     * WARNING - void declaration
     */
    public Bytes xor(byte[] secondArray) {
        void var1_1;
        return this.transform(new BytesTransformer.BitWiseOperatorTransformer((byte[])var1_1, BytesTransformer.BitWiseOperatorTransformer.Mode.XOR));
    }

    /*
     * WARNING - void declaration
     */
    public Bytes and(Bytes bytes) {
        void var1_1;
        return this.and(var1_1.byteArray);
    }

    /*
     * WARNING - void declaration
     */
    public Bytes and(byte[] secondArray) {
        void var1_1;
        return this.transform(new BytesTransformer.BitWiseOperatorTransformer((byte[])var1_1, BytesTransformer.BitWiseOperatorTransformer.Mode.AND));
    }

    /*
     * WARNING - void declaration
     */
    public Bytes or(Bytes bytes) {
        void var1_1;
        return this.or(var1_1.byteArray);
    }

    /*
     * WARNING - void declaration
     */
    public Bytes or(byte[] secondArray) {
        void var1_1;
        return this.transform(new BytesTransformer.BitWiseOperatorTransformer((byte[])var1_1, BytesTransformer.BitWiseOperatorTransformer.Mode.OR));
    }

    public Bytes not() {
        return this.transform(new BytesTransformer.NegateTransformer());
    }

    /*
     * WARNING - void declaration
     */
    public Bytes leftShift(int shiftCount) {
        void var1_1;
        return this.transform(new BytesTransformer.ShiftTransformer((int)var1_1, BytesTransformer.ShiftTransformer.Type.LEFT_SHIFT));
    }

    /*
     * WARNING - void declaration
     */
    public Bytes rightShift(int shiftCount) {
        void var1_1;
        return this.transform(new BytesTransformer.ShiftTransformer((int)var1_1, BytesTransformer.ShiftTransformer.Type.RIGHT_SHIFT));
    }

    /*
     * WARNING - void declaration
     */
    public Bytes switchBit(int bitPosition, boolean newBitValue) {
        void var2_2;
        void var1_1;
        return this.transform(new BytesTransformer.BitSwitchTransformer((int)var1_1, (boolean)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public Bytes switchBit(int bitPosition) {
        void var1_1;
        return this.transform(new BytesTransformer.BitSwitchTransformer((int)var1_1, null));
    }

    public Bytes copy() {
        return this.transform(new BytesTransformer.CopyTransformer(0, this.length()));
    }

    /*
     * WARNING - void declaration
     */
    public Bytes copy(int offset, int length) {
        void var2_2;
        void var1_1;
        return this.transform(new BytesTransformer.CopyTransformer((int)var1_1, (int)var2_2));
    }

    public Bytes reverse() {
        return this.transform(new BytesTransformer.ReverseTransformer());
    }

    /*
     * WARNING - void declaration
     */
    public Bytes resize(int newByteLength) {
        void var1_1;
        return this.resize((int)var1_1, BytesTransformer.ResizeTransformer.Mode.RESIZE_KEEP_FROM_MAX_LENGTH);
    }

    /*
     * WARNING - void declaration
     */
    public Bytes resize(int newByteLength, BytesTransformer.ResizeTransformer.Mode mode) {
        void var2_2;
        void var1_1;
        return this.transform(new BytesTransformer.ResizeTransformer((int)var1_1, (BytesTransformer.ResizeTransformer.Mode)var2_2));
    }

    public Bytes hashSha256() {
        return this.hash("SHA-256");
    }

    /*
     * WARNING - void declaration
     */
    public Bytes hash(String algorithm) {
        void var1_1;
        return this.transform(new BytesTransformer.MessageDigestTransformer((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Bytes transform(BytesTransformer transformer) {
        void var1_1;
        return this.factory.wrap(var1_1.transform(this.byteArray, this.isMutable()), this.byteOrder);
    }

    public boolean validateNotOnlyZeros() {
        return this.validate(BytesValidators.notOnlyOf((byte)0));
    }

    /*
     * WARNING - void declaration
     */
    public boolean validate(BytesValidator ... bytesValidators) {
        void var1_1;
        Objects.requireNonNull(bytesValidators);
        return BytesValidators.and((BytesValidator[])var1_1).validate(this.byteArray);
    }

    public int length() {
        return this.byteArray.length;
    }

    public int lengthBit() {
        return this.length() * 8;
    }

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public ByteOrder byteOrder() {
        return this.byteOrder;
    }

    public boolean isMutable() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(byte target) {
        void var1_1;
        return this.indexOf((byte)var1_1) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public int indexOf(byte target) {
        void var1_1;
        int n = this.length();
        void var2_4 = var1_1;
        byte[] byArray = this.byteArray;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] != var2_4) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(byte[] subArray) {
        byte[] byArray;
        void var2_2 = byArray;
        byArray = this.byteArray;
        Objects.requireNonNull(this.byteArray, "array must not be null");
        Objects.requireNonNull(var2_2, "target must not be null");
        if (((void)var2_2).length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < byArray.length - ((void)var2_2).length + 1; ++i) {
            for (int j = 0; j < ((void)var2_2).length; ++j) {
                if (byArray[i + j] != var2_2[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public int lastIndexOf(byte target) {
        void var1_1;
        int n = this.length();
        void var2_4 = var1_1;
        byte[] byArray = this.byteArray;
        --n;
        while (n >= 0) {
            if (byArray[n] == var2_4) {
                return n;
            }
            --n;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean bitAt(int bitIndex) {
        void var1_1;
        Util.checkIndexBounds(this.lengthBit(), bitIndex, 1, "bit");
        Bytes bytes = this;
        return (bytes.byteAt(bytes.length() - 1 - bitIndex / 8) >>> var1_1 % 8 & 1) != 0;
    }

    /*
     * WARNING - void declaration
     */
    public byte byteAt(int index) {
        void var1_1;
        Util.checkIndexBounds(this.length(), index, 1, "byte");
        return this.byteArray[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public int unsignedByteAt(int index) {
        void var1_1;
        Util.checkIndexBounds(this.length(), index, 1, "unsigned byte");
        return 0xFF & this.byteArray[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public char charAt(int index) {
        void var1_1;
        Util.checkIndexBounds(this.length(), index, 2, "char");
        return ((ByteBuffer)ByteBuffer.wrap(this.byteArray).order(this.byteOrder).position((int)var1_1)).getChar();
    }

    /*
     * WARNING - void declaration
     */
    public short shortAt(int index) {
        void var1_1;
        Util.checkIndexBounds(this.length(), index, 2, "short");
        return ((ByteBuffer)ByteBuffer.wrap(this.byteArray).order(this.byteOrder).position((int)var1_1)).getShort();
    }

    /*
     * WARNING - void declaration
     */
    public int intAt(int index) {
        void var1_1;
        Util.checkIndexBounds(this.length(), index, 4, "int");
        return ((ByteBuffer)ByteBuffer.wrap(this.byteArray).order(this.byteOrder).position((int)var1_1)).getInt();
    }

    /*
     * WARNING - void declaration
     */
    public long longAt(int index) {
        void var1_1;
        Util.checkIndexBounds(this.length(), index, 8, "long");
        return ((ByteBuffer)ByteBuffer.wrap(this.byteArray).order(this.byteOrder).position((int)var1_1)).getLong();
    }

    /*
     * WARNING - void declaration
     */
    public int count(byte target) {
        void var2_2;
        int count = 0;
        byte[] byArray = this.byteArray;
        int n = this.byteArray.length;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] != target) continue;
            ++count;
        }
        return (int)var2_2;
    }

    public double entropy() {
        return new Util.Entropy<Byte>(this.toList()).entropy();
    }

    public Bytes duplicate() {
        return this.factory.wrap(this.byteArray, this.byteOrder);
    }

    /*
     * WARNING - void declaration
     */
    public Bytes byteOrder(ByteOrder byteOrder) {
        if (byteOrder != this.byteOrder) {
            void var1_1;
            return Bytes.wrap(this.byteArray, (ByteOrder)var1_1);
        }
        return this;
    }

    public ReadOnlyBytes readOnly() {
        if (this.isReadOnly()) {
            return (ReadOnlyBytes)this;
        }
        return new ReadOnlyBytes(this.byteArray, this.byteOrder);
    }

    public ByteBuffer buffer() {
        return ByteBuffer.wrap(this.array()).order(this.byteOrder);
    }

    private ByteBuffer internalBuffer() {
        return ByteBuffer.wrap(this.byteArray).order(this.byteOrder);
    }

    public MutableBytes mutable() {
        if (this instanceof MutableBytes) {
            return (MutableBytes)this;
        }
        return new MutableBytes(this.array(), this.byteOrder);
    }

    public InputStream inputStream() {
        return new ByteArrayInputStream(this.array());
    }

    public byte[] array() {
        return this.byteArray;
    }

    final byte[] internalArray() {
        return this.byteArray;
    }

    public String encodeBinary() {
        return this.encode(new BinaryToTextEncoding.BaseRadix(2));
    }

    public String encodeOctal() {
        return this.encode(new BinaryToTextEncoding.BaseRadix(8));
    }

    public String encodeDec() {
        return this.encode(new BinaryToTextEncoding.BaseRadix(10));
    }

    public String encodeHex() {
        return this.encodeHex(false);
    }

    /*
     * WARNING - void declaration
     */
    public String encodeHex(boolean upperCase) {
        void var1_1;
        return this.encode(new BinaryToTextEncoding.Hex((boolean)var1_1));
    }

    public String encodeBase36() {
        return this.encode(new BinaryToTextEncoding.BaseRadix(36));
    }

    public String encodeBase64() {
        return this.encode(new BinaryToTextEncoding.Base64Encoding());
    }

    public String encodeUtf8() {
        return this.encodeCharset(StandardCharsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public String encodeCharset(Charset charset) {
        void var1_1;
        Objects.requireNonNull(charset, "given charset must not be null");
        return new String(this.byteArray, (Charset)var1_1);
    }

    public byte[] encodeUtf8ToBytes() {
        return this.encodeCharsetToBytes(StandardCharsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] encodeCharsetToBytes(Charset charset) {
        void var1_1;
        return this.encodeCharset(charset).getBytes((Charset)var1_1);
    }

    public String encode(BinaryToTextEncoding.Encoder encoder) {
        return encoder.encode(this.byteArray, this.byteOrder);
    }

    public List<Byte> toList() {
        byte[] byArray = this.byteArray;
        ArrayList<Byte> arrayList = new ArrayList<Byte>(byArray.length);
        for (byte by : byArray) {
            arrayList.add(by);
        }
        return arrayList;
    }

    @Deprecated
    public Byte[] toObjectArray() {
        return this.toBoxedArray();
    }

    public Byte[] toBoxedArray() {
        byte[] byArray = this.byteArray;
        Byte[] byteArray = new Byte[this.byteArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byteArray[i] = byArray[i];
        }
        return byteArray;
    }

    public BitSet toBitSet() {
        return BitSet.valueOf(this.byteArray);
    }

    public BigInteger toBigInteger() {
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return new BigInteger(new BytesTransformer.ReverseTransformer().transform(this.byteArray, false));
        }
        return new BigInteger(this.byteArray);
    }

    /*
     * WARNING - void declaration
     */
    public UUID toUUID() {
        void var1_1;
        if (this.length() != 16) {
            throw new IllegalStateException("creating UUID requires internal array to be exactly 16 bytes, was " + this.length());
        }
        ByteBuffer byteBuffer = this.buffer();
        return new UUID(byteBuffer.getLong(), var1_1.getLong());
    }

    public byte toByte() {
        Util.checkExactLength(this.length(), 1, "byte");
        return this.byteArray[0];
    }

    public int toUnsignedByte() {
        Util.checkExactLength(this.length(), 1, "unsigned byte");
        return this.unsignedByteAt(0);
    }

    public char toChar() {
        Util.checkExactLength(this.length(), 2, "char");
        return this.charAt(0);
    }

    public short toShort() {
        Util.checkExactLength(this.length(), 2, "short");
        return this.shortAt(0);
    }

    public int toInt() {
        Util.checkExactLength(this.length(), 4, "int");
        return this.intAt(0);
    }

    public long toLong() {
        Util.checkExactLength(this.length(), 8, "long");
        return this.longAt(0);
    }

    public float toFloat() {
        Util.checkExactLength(this.length(), 4, "float");
        return this.internalBuffer().getFloat();
    }

    public double toDouble() {
        Util.checkExactLength(this.length(), 8, "double");
        return this.internalBuffer().getDouble();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(Bytes o) {
        void var1_1;
        return this.internalBuffer().compareTo(super.internalBuffer());
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bytes bytes = (Bytes)o;
        if (!Arrays.equals(this.byteArray, bytes.byteArray)) {
            return false;
        }
        if (this.byteOrder != null) {
            return this.byteOrder.equals(bytes.byteOrder);
        }
        return var1_1.byteOrder == null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(byte[] anotherArray) {
        void var1_1;
        return anotherArray != null && Arrays.equals(this.byteArray, (byte[])var1_1);
    }

    public boolean equalsConstantTime(byte[] anotherArray) {
        if (anotherArray != null) {
            boolean bl;
            byte[] byArray;
            void var2_2 = byArray;
            byArray = this.byteArray;
            if (var2_2 == null || byArray.length != ((void)var2_2).length) {
                bl = false;
            } else {
                int n = 0;
                for (int i = 0; i < byArray.length; ++i) {
                    n |= byArray[i] ^ var2_2[i];
                }
                bl = n == 0;
            }
            if (bl) {
                return true;
            }
        }
        return false;
    }

    public boolean equals(Byte[] anotherArray) {
        byte[] byArray;
        void var2_2 = byArray;
        byArray = this.byteArray;
        if (var2_2 == null) {
            return false;
        }
        if (byArray.length != ((void)var2_2).length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (var2_2[i] != null && byArray[i] == var2_2[i].byteValue()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(ByteBuffer buffer) {
        void var1_1;
        return buffer != null && this.byteOrder == buffer.order() && ByteBuffer.wrap(this.byteArray).order(this.byteOrder).equals(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equalsContent(Bytes other) {
        void var1_1;
        return other != null && Arrays.equals(this.byteArray, var1_1.byteArray);
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = Arrays.hashCode(this.byteArray);
        return 31 * var1_1 + (this.byteOrder != null ? this.byteOrder.hashCode() : 0);
    }

    public String toString() {
        String string;
        Bytes bytes = this;
        if (bytes.isEmpty()) {
            string = "";
        } else if (bytes.length() > 8) {
            Bytes bytes2 = bytes;
            string = "(0x" + bytes.copy(0, 4).encodeHex() + "..." + bytes2.copy(bytes2.length() - 4, 4).encodeHex() + ")";
        } else {
            string = "(0x" + bytes.encodeHex() + ")";
        }
        return bytes.length() + " " + (bytes.length() == 1 ? "byte" : "bytes") + " " + string;
    }

    @Override
    public Iterator<Byte> iterator() {
        return new Util.BytesIterator(this.byteArray);
    }

    private static final class Factory
    implements BytesFactory {
        private Factory() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Bytes wrap(byte[] array, ByteOrder byteOrder) {
            void var2_2;
            void var1_1;
            return new Bytes((byte[])var1_1, (ByteOrder)var2_2);
        }

        /* synthetic */ Factory(byte by) {
            this();
        }
    }
}

