/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.bytes;

import at.favre.lib.bytes.BinaryToTextEncoding;
import at.favre.lib.bytes.BytesFactory;
import at.favre.lib.bytes.BytesTransformer;
import at.favre.lib.bytes.BytesValidator;
import at.favre.lib.bytes.BytesValidators;
import at.favre.lib.bytes.MutableBytes;
import at.favre.lib.bytes.ReadOnlyBytes;
import at.favre.lib.bytes.Util;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;

public class Bytes
implements Comparable<Bytes>,
Serializable,
Iterable<Byte> {
    private final byte[] byteArray;
    private final ByteOrder byteOrder;
    private final BytesFactory factory;
    static final long serialVersionUID = 1L;

    public static Bytes allocate(int length) {
        return Bytes.allocate(length, (byte)0);
    }

    public static Bytes allocate(int length, byte defaultValue) {
        byte[] array = new byte[length];
        if (defaultValue != 0) {
            Arrays.fill(array, defaultValue);
        }
        return Bytes.wrap(array);
    }

    public static Bytes wrap(Bytes bytes) {
        return new Bytes(bytes.internalArray(), bytes.byteOrder);
    }

    public static Bytes wrapNullSafe(byte[] array) {
        return Bytes.wrap(array != null ? array : new byte[]{}, ByteOrder.BIG_ENDIAN);
    }

    public static Bytes wrap(byte[] array) {
        return Bytes.wrap(array, ByteOrder.BIG_ENDIAN);
    }

    public static Bytes wrap(byte[] array, ByteOrder byteOrder) {
        Objects.requireNonNull(array, "passed array must not be null");
        return new Bytes(array, byteOrder);
    }

    public static Bytes from(byte[] byteArrayToCopy) {
        Objects.requireNonNull(byteArrayToCopy, "must at least pass a single byte");
        return Bytes.wrap(Arrays.copyOf(byteArrayToCopy, byteArrayToCopy.length));
    }

    public static Bytes from(byte[] array, int offset, int length) {
        Objects.requireNonNull(array, "passed array must not be null");
        byte[] part = new byte[length];
        System.arraycopy(array, offset, part, 0, length);
        return Bytes.wrap(part);
    }

    public static Bytes from(byte[] ... moreArrays) {
        return Bytes.wrap(Util.concat(moreArrays));
    }

    public static Bytes from(Bytes ... moreBytes) {
        Objects.requireNonNull(moreBytes, "bytes most not be null");
        byte[][] bytes = new byte[moreBytes.length][];
        for (int i = 0; i < moreBytes.length; ++i) {
            bytes[i] = moreBytes[i].array();
        }
        return Bytes.from(bytes);
    }

    public static Bytes from(Collection<Byte> bytesCollection) {
        return Bytes.wrap(Util.toArray(bytesCollection));
    }

    public static Bytes from(Byte[] objectArray) {
        return Bytes.wrap(Util.toPrimitiveArray(objectArray));
    }

    public static Bytes from(byte singleByte) {
        return Bytes.wrap(new byte[]{singleByte});
    }

    public static Bytes from(byte firstByte, byte ... moreBytes) {
        return Bytes.wrap(Util.concatVararg(firstByte, moreBytes));
    }

    public static Bytes from(char char2Byte) {
        return Bytes.wrap(ByteBuffer.allocate(2).putChar(char2Byte).array());
    }

    public static Bytes from(short short2Byte) {
        return Bytes.wrap(ByteBuffer.allocate(2).putShort(short2Byte).array());
    }

    public static Bytes from(int integer4byte) {
        return Bytes.wrap(ByteBuffer.allocate(4).putInt(integer4byte).array());
    }

    public static Bytes from(int ... intArray) {
        Objects.requireNonNull(intArray, "must provide at least a single int");
        return Bytes.wrap(Util.toByteArray(intArray));
    }

    public static Bytes from(long long8byte) {
        return Bytes.wrap(ByteBuffer.allocate(8).putLong(long8byte).array());
    }

    public static Bytes from(long ... longArray) {
        Objects.requireNonNull(longArray, "must provide at least a single long");
        return Bytes.wrap(Util.toByteArray(longArray));
    }

    public static Bytes from(ByteBuffer buffer) {
        return Bytes.wrap(buffer.array(), buffer.order());
    }

    public static Bytes from(BitSet set) {
        return Bytes.wrap(set.toByteArray());
    }

    public static Bytes from(BigInteger bigInteger) {
        return Bytes.wrap(bigInteger.toByteArray());
    }

    public static Bytes from(InputStream stream) {
        return Bytes.wrap(Util.readFromStream(stream));
    }

    public static Bytes from(DataInput dataInput, int length) {
        return Bytes.wrap(Util.readFromDataInput(dataInput, length));
    }

    public static Bytes from(File file) {
        return Bytes.wrap(Util.readFromFile(file));
    }

    public static Bytes from(CharSequence utf8String) {
        return Bytes.from(utf8String, StandardCharsets.UTF_8);
    }

    public static Bytes from(CharSequence utf8String, Normalizer.Form form) {
        return Bytes.from((CharSequence)Normalizer.normalize(utf8String, form), StandardCharsets.UTF_8);
    }

    public static Bytes from(CharSequence string, Charset charset) {
        return Bytes.wrap(string.toString().getBytes(charset));
    }

    public static Bytes parseBinary(String binaryString) {
        return Bytes.parse(binaryString, new BinaryToTextEncoding.BaseRadix(2));
    }

    public static Bytes parseOctal(String octalString) {
        return Bytes.parse(octalString, new BinaryToTextEncoding.BaseRadix(8));
    }

    public static Bytes parseDec(String decString) {
        return Bytes.parse(decString, new BinaryToTextEncoding.BaseRadix(10));
    }

    public static Bytes parseHex(String hexString) {
        return Bytes.parse(hexString, new BinaryToTextEncoding.Hex());
    }

    public static Bytes parseBase36(String base36String) {
        return Bytes.parse(base36String, new BinaryToTextEncoding.BaseRadix(36));
    }

    public static Bytes parseBase64(String base64String) {
        return Bytes.parse(base64String, new BinaryToTextEncoding.Base64Encoding());
    }

    public static Bytes parse(String encoded, BinaryToTextEncoding.Decoder decoder) {
        Objects.requireNonNull(encoded, "encoded data must not be null");
        Objects.requireNonNull(decoder, "passed decoder instance must no be null");
        return Bytes.wrap(decoder.decode(encoded));
    }

    public static Bytes random(int length) {
        return Bytes.random(length, new SecureRandom());
    }

    public static Bytes random(int length, Random random) {
        byte[] array = new byte[length];
        random.nextBytes(array);
        return Bytes.wrap(array);
    }

    Bytes(byte[] byteArray, ByteOrder byteOrder) {
        this(byteArray, byteOrder, new Factory());
    }

    Bytes(byte[] byteArray, ByteOrder byteOrder, BytesFactory factory) {
        this.byteArray = byteArray;
        this.byteOrder = byteOrder;
        this.factory = factory;
    }

    public Bytes append(Bytes bytes) {
        return this.append(bytes.internalArray());
    }

    public Bytes append(byte singleByte) {
        return this.append(Bytes.from(singleByte));
    }

    public Bytes append(char char2Bytes) {
        return this.append(Bytes.from(char2Bytes));
    }

    public Bytes append(short short2Bytes) {
        return this.append(Bytes.from(short2Bytes));
    }

    public Bytes append(int integer4Bytes) {
        return this.append(Bytes.from(integer4Bytes));
    }

    public Bytes append(long long8Bytes) {
        return this.append(Bytes.from(long8Bytes));
    }

    public Bytes append(byte[] secondArray) {
        return this.transform(new BytesTransformer.ConcatTransformer(secondArray));
    }

    public Bytes xor(Bytes bytes) {
        return this.xor(bytes.internalArray());
    }

    public Bytes xor(byte[] secondArray) {
        return this.transform(new BytesTransformer.BitWiseOperatorTransformer(secondArray, BytesTransformer.BitWiseOperatorTransformer.Mode.XOR));
    }

    public Bytes and(Bytes bytes) {
        return this.and(bytes.internalArray());
    }

    public Bytes and(byte[] secondArray) {
        return this.transform(new BytesTransformer.BitWiseOperatorTransformer(secondArray, BytesTransformer.BitWiseOperatorTransformer.Mode.AND));
    }

    public Bytes or(Bytes bytes) {
        return this.and(bytes.internalArray());
    }

    public Bytes or(byte[] secondArray) {
        return this.transform(new BytesTransformer.BitWiseOperatorTransformer(secondArray, BytesTransformer.BitWiseOperatorTransformer.Mode.OR));
    }

    public Bytes not() {
        return this.transform(new BytesTransformer.NegateTransformer());
    }

    public Bytes leftShift(int shiftCount) {
        return this.transform(new BytesTransformer.ShiftTransformer(shiftCount, BytesTransformer.ShiftTransformer.Type.LEFT_SHIFT));
    }

    public Bytes rightShift(int shiftCount) {
        return this.transform(new BytesTransformer.ShiftTransformer(shiftCount, BytesTransformer.ShiftTransformer.Type.RIGHT_SHIFT));
    }

    public Bytes switchBit(int bitPosition, boolean newBitValue) {
        return this.transform(new BytesTransformer.BitSwitchTransformer(bitPosition, newBitValue));
    }

    public Bytes switchBit(int bitPosition) {
        return this.transform(new BytesTransformer.BitSwitchTransformer(bitPosition, null));
    }

    public Bytes copy() {
        return this.transform(new BytesTransformer.CopyTransformer(0, this.length()));
    }

    public Bytes copy(int offset, int length) {
        return this.transform(new BytesTransformer.CopyTransformer(offset, length));
    }

    public Bytes reverse() {
        return this.transform(new BytesTransformer.ReverseTransformer());
    }

    public Bytes resize(int newByteLength) {
        return this.resize(newByteLength, BytesTransformer.ResizeTransformer.Mode.RESIZE_KEEP_FROM_MAX_LENGTH);
    }

    public Bytes resize(int newByteLength, BytesTransformer.ResizeTransformer.Mode mode) {
        return this.transform(new BytesTransformer.ResizeTransformer(newByteLength, mode));
    }

    public Bytes hashSha256() {
        return this.hash("SHA-256");
    }

    public Bytes hash(String algorithm) {
        return this.transform(new BytesTransformer.MessageDigestTransformer(algorithm));
    }

    public Bytes transform(BytesTransformer transformer) {
        return this.factory.wrap(transformer.transform(this.internalArray(), this.isMutable()), this.byteOrder);
    }

    public boolean validateNotOnlyZeros() {
        return this.validate(BytesValidators.notOnlyOf((byte)0));
    }

    public boolean validate(BytesValidator ... bytesValidators) {
        Objects.requireNonNull(bytesValidators);
        return BytesValidators.and(bytesValidators).validate(this.internalArray());
    }

    public int length() {
        return this.internalArray().length;
    }

    public int lengthBit() {
        return this.length() * 8;
    }

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public ByteOrder byteOrder() {
        return this.byteOrder;
    }

    public boolean isMutable() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean contains(byte target) {
        return this.indexOf(target) != -1;
    }

    public int indexOf(byte target) {
        return Util.indexOf(this.internalArray(), target, 0, this.length());
    }

    public int indexOf(byte[] subArray) {
        return Util.indexOf(this.internalArray(), subArray);
    }

    public int lastIndexOf(byte target) {
        return Util.lastIndexOf(this.internalArray(), target, 0, this.length());
    }

    public boolean bitAt(int bitIndex) {
        Util.checkIndexBounds(this.lengthBit(), bitIndex, 1, "bit");
        return (this.byteAt(this.length() - 1 - bitIndex / 8) >>> bitIndex % 8 & 1) != 0;
    }

    public byte byteAt(int index) {
        Util.checkIndexBounds(this.length(), index, 1, "byte");
        return this.internalArray()[index];
    }

    public int unsignedByteAt(int index) {
        Util.checkIndexBounds(this.length(), index, 1, "unsigned byte");
        return 0xFF & this.internalArray()[index];
    }

    public char charAt(int index) {
        Util.checkIndexBounds(this.length(), index, 2, "char");
        return ((ByteBuffer)ByteBuffer.wrap(this.internalArray()).order(this.byteOrder).position(index)).getChar();
    }

    public short shortAt(int index) {
        Util.checkIndexBounds(this.length(), index, 2, "short");
        return ((ByteBuffer)ByteBuffer.wrap(this.internalArray()).order(this.byteOrder).position(index)).getShort();
    }

    public int intAt(int index) {
        Util.checkIndexBounds(this.length(), index, 4, "int");
        return ((ByteBuffer)ByteBuffer.wrap(this.internalArray()).order(this.byteOrder).position(index)).getInt();
    }

    public long longAt(int index) {
        Util.checkIndexBounds(this.length(), index, 8, "long");
        return ((ByteBuffer)ByteBuffer.wrap(this.internalArray()).order(this.byteOrder).position(index)).getLong();
    }

    public int count(byte target) {
        int count = 0;
        for (byte b : this.internalArray()) {
            if (b != target) continue;
            ++count;
        }
        return count;
    }

    public double entropy() {
        return new Util.Entropy<Byte>(this.toList()).entropy();
    }

    public Bytes duplicate() {
        return this.factory.wrap(this.internalArray(), this.byteOrder);
    }

    public Bytes byteOrder(ByteOrder byteOrder) {
        if (byteOrder != this.byteOrder) {
            return Bytes.wrap(this.internalArray(), byteOrder);
        }
        return this;
    }

    public ReadOnlyBytes readOnly() {
        if (this.isReadOnly()) {
            return (ReadOnlyBytes)this;
        }
        return new ReadOnlyBytes(this.internalArray(), this.byteOrder);
    }

    public ByteBuffer buffer() {
        return ByteBuffer.wrap(this.array()).order(this.byteOrder);
    }

    private ByteBuffer internalBuffer() {
        return ByteBuffer.wrap(this.internalArray()).order(this.byteOrder);
    }

    public MutableBytes mutable() {
        if (this instanceof MutableBytes) {
            return (MutableBytes)this;
        }
        return new MutableBytes(this.array(), this.byteOrder);
    }

    public InputStream inputStream() {
        return new ByteArrayInputStream(this.array());
    }

    public byte[] array() {
        return this.internalArray();
    }

    byte[] internalArray() {
        return this.byteArray;
    }

    public String encodeBinary() {
        return this.encode(new BinaryToTextEncoding.BaseRadix(2));
    }

    public String encodeOctal() {
        return this.encode(new BinaryToTextEncoding.BaseRadix(8));
    }

    public String encodeDec() {
        return this.encode(new BinaryToTextEncoding.BaseRadix(10));
    }

    public String encodeHex() {
        return this.encodeHex(false);
    }

    public String encodeHex(boolean upperCase) {
        return this.encode(new BinaryToTextEncoding.Hex(upperCase));
    }

    public String encodeBase36() {
        return this.encode(new BinaryToTextEncoding.BaseRadix(36));
    }

    public String encodeBase64() {
        return this.encode(new BinaryToTextEncoding.Base64Encoding());
    }

    public String encodeUtf8() {
        return this.encodeCharset(StandardCharsets.UTF_8);
    }

    public String encodeCharset(Charset charset) {
        Objects.requireNonNull(charset, "given charset must not be null");
        return new String(this.internalArray(), charset);
    }

    public String encode(BinaryToTextEncoding.Encoder encoder) {
        return encoder.encode(this.internalArray(), this.byteOrder);
    }

    public List<Byte> toList() {
        return Util.toList(this.internalArray());
    }

    public Byte[] toObjectArray() {
        return Util.toObjectArray(this.internalArray());
    }

    public BitSet toBitSet() {
        return BitSet.valueOf(this.internalArray());
    }

    public BigInteger toBigInteger() {
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return new BigInteger(new BytesTransformer.ReverseTransformer().transform(this.internalArray(), false));
        }
        return new BigInteger(this.internalArray());
    }

    public byte toByte() {
        Util.checkExactLength(this.length(), 1, "byte");
        return this.internalArray()[0];
    }

    public int toUnsignedByte() {
        Util.checkExactLength(this.length(), 1, "unsigned byte");
        return this.unsignedByteAt(0);
    }

    public char toChar() {
        Util.checkExactLength(this.length(), 2, "char");
        return this.charAt(0);
    }

    public short toShort() {
        Util.checkExactLength(this.length(), 2, "short");
        return this.shortAt(0);
    }

    public int toInt() {
        Util.checkExactLength(this.length(), 4, "int");
        return this.intAt(0);
    }

    public long toLong() {
        Util.checkExactLength(this.length(), 8, "long");
        return this.longAt(0);
    }

    public float toFloat() {
        Util.checkExactLength(this.length(), 4, "float");
        return this.internalBuffer().getFloat();
    }

    public double toDouble() {
        Util.checkExactLength(this.length(), 8, "double");
        return this.internalBuffer().getDouble();
    }

    @Override
    public int compareTo(Bytes o) {
        return this.internalBuffer().compareTo(o.internalBuffer());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bytes bytes = (Bytes)o;
        if (!Arrays.equals(this.byteArray, bytes.byteArray)) {
            return false;
        }
        return this.byteOrder != null ? this.byteOrder.equals(bytes.byteOrder) : bytes.byteOrder == null;
    }

    public boolean equals(byte[] anotherArray) {
        return anotherArray != null && Arrays.equals(this.internalArray(), anotherArray);
    }

    public boolean equals(Byte[] anotherArray) {
        return Util.equals(this.internalArray(), anotherArray);
    }

    public boolean equals(ByteBuffer buffer) {
        return buffer != null && this.byteOrder == buffer.order() && ByteBuffer.wrap(this.internalArray()).order(this.byteOrder).equals(buffer);
    }

    public boolean equalsContent(Bytes other) {
        return other != null && Arrays.equals(this.internalArray(), other.internalArray());
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.byteArray);
        result = 31 * result + (this.byteOrder != null ? this.byteOrder.hashCode() : 0);
        return result;
    }

    public String toString() {
        return Util.toString(this);
    }

    @Override
    public Iterator<Byte> iterator() {
        return new Util.BytesIterator(this.internalArray());
    }

    private static class Factory
    implements BytesFactory {
        private Factory() {
        }

        @Override
        public Bytes wrap(byte[] array, ByteOrder byteOrder) {
            return new Bytes(array, byteOrder);
        }
    }
}

