/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.bytes;

import at.favre.lib.bytes.Base64;
import at.favre.lib.bytes.Bytes;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.util.Objects;

public interface BinaryToTextEncoding {

    public static class BaseRadix
    implements Encoder,
    Decoder {
        private final int radix;

        BaseRadix(int radix) {
            this.radix = radix;
        }

        @Override
        public String encode(byte[] array, ByteOrder byteOrder) {
            return new BigInteger(1, byteOrder == ByteOrder.BIG_ENDIAN ? array : Bytes.from(array).reverse().array()).toString(this.radix);
        }

        @Override
        public byte[] decode(String encoded) {
            return new BigInteger(encoded, this.radix).toByteArray();
        }
    }

    public static class Base64Encoding
    implements Encoder,
    Decoder {
        @Override
        public String encode(byte[] array, ByteOrder byteOrder) {
            return Base64.encode(byteOrder == ByteOrder.BIG_ENDIAN ? array : Bytes.from(array).reverse().array());
        }

        @Override
        public byte[] decode(String encoded) {
            return Base64.decode(encoded);
        }
    }

    public static class Hex
    implements Encoder,
    Decoder {
        private final boolean upperCase;

        public Hex() {
            this(true);
        }

        public Hex(boolean upperCase) {
            this.upperCase = upperCase;
        }

        @Override
        public String encode(byte[] byteArray, ByteOrder byteOrder) {
            StringBuilder sb = new StringBuilder(byteArray.length * 2);
            for (int i = 0; i < byteArray.length; ++i) {
                int index = byteOrder == ByteOrder.BIG_ENDIAN ? i : byteArray.length - i - 1;
                char first4Bit = Character.forDigit(byteArray[index] >> 4 & 0xF, 16);
                char last4Bit = Character.forDigit(byteArray[index] & 0xF, 16);
                if (this.upperCase) {
                    first4Bit = Character.toUpperCase(first4Bit);
                    last4Bit = Character.toUpperCase(last4Bit);
                }
                sb.append(first4Bit).append(last4Bit);
            }
            return sb.toString();
        }

        @Override
        public byte[] decode(String hexString) {
            Objects.requireNonNull(hexString, "hex input must not be null");
            if (hexString.length() % 2 != 0) {
                throw new IllegalArgumentException("invalid hex string, must be mod 2 == 0");
            }
            int start = hexString.startsWith("0x") ? 2 : 0;
            int len = hexString.length();
            byte[] data = new byte[(len - start) / 2];
            for (int i = start; i < len; i += 2) {
                int first4Bits = Character.digit(hexString.charAt(i), 16);
                int second4Bits = Character.digit(hexString.charAt(i + 1), 16);
                if (first4Bits == -1 || second4Bits == -1) {
                    throw new IllegalArgumentException("'" + hexString.charAt(i) + hexString.charAt(i + 1) + "' at index " + i + " is not hex formatted");
                }
                data[(i - start) / 2] = (byte)((first4Bits << 4) + second4Bits);
            }
            return data;
        }
    }

    public static interface Decoder {
        public byte[] decode(String var1);
    }

    public static interface Encoder {
        public String encode(byte[] var1, ByteOrder var2);
    }
}

