/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.bytes;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;

final class Util {
    private static final int BUF_SIZE = 4096;

    private Util() {
    }

    static byte[] concat(byte[] ... arrays) {
        int length = 0;
        for (byte[] array : arrays) {
            length += array.length;
        }
        byte[] result = new byte[length];
        int pos = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, result, pos, array.length);
            pos += array.length;
        }
        return result;
    }

    static int indexOf(byte[] array, byte target, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(byte[] array, byte[] target) {
        Objects.requireNonNull(array, "array must not be null");
        Objects.requireNonNull(target, "target must not be null");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < array.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    static int lastIndexOf(byte[] array, byte target, int start, int end) {
        for (int i = end - 1; i >= start; --i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    static byte[] toArray(Collection<Byte> collection) {
        Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        byte[] array = new byte[len];
        for (int i = 0; i < len; ++i) {
            array[i] = (Byte)boxedArray[i];
        }
        return array;
    }

    static List<Byte> toList(byte[] array) {
        ArrayList<Byte> list = new ArrayList<Byte>(array.length);
        for (byte b : array) {
            list.add(b);
        }
        return list;
    }

    static Byte[] toObjectArray(byte[] array) {
        Byte[] objectArray = new Byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            objectArray[i] = array[i];
        }
        return objectArray;
    }

    static byte[] toPrimitiveArray(Byte[] objectArray) {
        byte[] primitivesArray = new byte[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            primitivesArray[i] = objectArray[i];
        }
        return primitivesArray;
    }

    static byte[] toByteArray(int[] intArray) {
        byte[] primitivesArray = new byte[intArray.length * 4];
        for (int i = 0; i < intArray.length; ++i) {
            byte[] intBytes = ByteBuffer.allocate(4).putInt(intArray[i]).array();
            for (int j = 0; j < intBytes.length; ++j) {
                primitivesArray[i * 4 + j] = intBytes[j];
            }
        }
        return primitivesArray;
    }

    static byte[] toByteArray(long[] longArray) {
        byte[] primitivesArray = new byte[longArray.length * 8];
        for (int i = 0; i < longArray.length; ++i) {
            byte[] longBytes = ByteBuffer.allocate(8).putLong(longArray[i]).array();
            for (int j = 0; j < longBytes.length; ++j) {
                primitivesArray[i * 8 + j] = longBytes[j];
            }
        }
        return primitivesArray;
    }

    static void shuffle(byte[] array, Random random) {
        for (int i = array.length - 1; i > 0; --i) {
            int index = random.nextInt(i + 1);
            byte a = array[index];
            array[index] = array[i];
            array[i] = a;
        }
    }

    static byte[] readFromStream(InputStream inputStream) {
        try {
            int r;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            while ((r = inputStream.read(buf)) != -1) {
                out.write(buf, 0, r);
            }
            return out.toByteArray();
        }
        catch (Exception e) {
            throw new IllegalStateException("could not read from input stream", e);
        }
    }

    static byte[] concatVararg(byte firstByte, byte[] moreBytes) {
        if (moreBytes == null) {
            return new byte[]{firstByte};
        }
        return Util.concat({firstByte}, moreBytes);
    }

    static byte[] readFromFile(File file) {
        if (file == null || !file.exists() || !file.isFile()) {
            throw new IllegalArgumentException("file must not be null, has to exist and must be a file (not a directory) " + file);
        }
        try {
            return Files.readAllBytes(file.toPath());
        }
        catch (IOException e) {
            throw new IllegalStateException("could not read from file", e);
        }
    }

    public static final class Entropy<T> {
        private final Map<T, Integer> map = new HashMap<T, Integer>();
        private int total = 0;

        private double Log2(double n) {
            return Math.log(n) / Math.log(2.0);
        }

        public Entropy(Iterable<T> elements) {
            for (T element : elements) {
                if (!this.map.containsKey(element)) {
                    this.map.put(element, 0);
                }
                this.map.put(element, this.map.get(element) + 1);
                ++this.total;
            }
        }

        public double entropy() {
            double entropy = 0.0;
            for (int count : this.map.values()) {
                double prob = (double)count / (double)this.total;
                entropy -= prob * this.Log2(prob);
            }
            return entropy;
        }
    }
}

