/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.bytes;

import at.favre.lib.bytes.BytesValidator;

public class BytesValidators {
    private BytesValidators() {
    }

    public static BytesValidator atLeast(int byteLength) {
        return new BytesValidator.Length(byteLength, BytesValidator.Length.Mode.GREATER_OR_EQ_THAN);
    }

    public static BytesValidator atMost(int byteLength) {
        return new BytesValidator.Length(byteLength, BytesValidator.Length.Mode.SMALLER_OR_EQ_THAN);
    }

    public static BytesValidator exactLength(int byteLength) {
        return new BytesValidator.Length(byteLength, BytesValidator.Length.Mode.EXACT);
    }

    public static BytesValidator onlyOf(byte value) {
        return new BytesValidator.IdenticalContent(value, BytesValidator.IdenticalContent.Mode.ONLY_OF);
    }

    public static BytesValidator notOnlyOf(byte value) {
        return new BytesValidator.IdenticalContent(value, BytesValidator.IdenticalContent.Mode.NOT_ONLY_OF);
    }

    public static BytesValidator noneOf(byte value) {
        return new BytesValidator.IdenticalContent(value, BytesValidator.IdenticalContent.Mode.NONE_OF);
    }
}

