/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.bytes;

public interface BytesValidator {
    public boolean validate(byte[] var1);

    public static final class IdenticalContent
    implements BytesValidator {
        private final byte refByte;
        private final Mode mode;

        IdenticalContent(byte refByte, Mode mode) {
            this.refByte = refByte;
            this.mode = mode;
        }

        @Override
        public boolean validate(byte[] byteArrayToValidate) {
            for (byte b : byteArrayToValidate) {
                if (this.mode == Mode.NONE_OF && b == this.refByte) {
                    return false;
                }
                if (this.mode == Mode.ONLY_OF && b != this.refByte) {
                    return false;
                }
                if (this.mode != Mode.NOT_ONLY_OF || b == this.refByte) continue;
                return true;
            }
            return this.mode == Mode.NONE_OF || this.mode == Mode.ONLY_OF;
        }

        static enum Mode {
            ONLY_OF,
            NONE_OF,
            NOT_ONLY_OF;

        }
    }

    public static final class Length
    implements BytesValidator {
        private final int refLength;
        private final Mode mode;

        public Length(int refLength, Mode mode) {
            this.refLength = refLength;
            this.mode = mode;
        }

        @Override
        public boolean validate(byte[] byteArrayToValidate) {
            switch (this.mode) {
                case GREATER_OR_EQ_THAN: {
                    return byteArrayToValidate.length >= this.refLength;
                }
                case SMALLER_OR_EQ_THAN: {
                    return byteArrayToValidate.length <= this.refLength;
                }
            }
            return byteArrayToValidate.length == this.refLength;
        }

        static enum Mode {
            SMALLER_OR_EQ_THAN,
            GREATER_OR_EQ_THAN,
            EXACT;

        }
    }
}

