/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.bytes;

public interface BytesValidator {
    public boolean validate(byte[] var1);

    public static final class IdenticalContent
    implements BytesValidator {
        final byte refByte;

        IdenticalContent(byte refByte) {
            this.refByte = refByte;
        }

        @Override
        public boolean validate(byte[] byteArrayToValidate) {
            for (byte b : byteArrayToValidate) {
                if (b == this.refByte) continue;
                return false;
            }
            return true;
        }
    }

    public static final class Length
    implements BytesValidator {
        private final int refLength;
        private final Mode mode;

        public Length(int refLength, Mode mode) {
            this.refLength = refLength;
            this.mode = mode;
        }

        @Override
        public boolean validate(byte[] byteArrayToValidate) {
            switch (this.mode) {
                case GREATER_THAN: {
                    return byteArrayToValidate.length > this.refLength;
                }
                case SMALLER_THAN: {
                    return byteArrayToValidate.length < this.refLength;
                }
            }
            return byteArrayToValidate.length == this.refLength;
        }

        static enum Mode {
            SMALLER_THAN,
            GREATER_THAN,
            EXACT;

        }
    }
}

