/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.bytes;

import at.favre.lib.bytes.Bytes;
import at.favre.lib.bytes.Util;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Random;

public interface BytesTransformer {
    public Bytes transform(Bytes var1, boolean var2);

    public static final class ShuffleTransformer
    implements BytesTransformer {
        private final Random random;

        public ShuffleTransformer(Random random) {
            Objects.requireNonNull(random, "passed random must not be null");
            this.random = random;
        }

        @Override
        public Bytes transform(Bytes victim, boolean inPlace) {
            byte[] out = inPlace ? victim.internalArray() : victim.copy().internalArray();
            Util.shuffle(out, this.random);
            return inPlace ? victim : new Bytes(out, victim);
        }
    }

    public static final class SortTransformer
    implements BytesTransformer {
        private final Comparator<Byte> comparator;

        public SortTransformer() {
            this(null);
        }

        public SortTransformer(Comparator<Byte> comparator) {
            this.comparator = comparator;
        }

        @Override
        public Bytes transform(Bytes victim, boolean inPlace) {
            if (this.comparator == null) {
                byte[] out = inPlace ? victim.internalArray() : victim.copy().internalArray();
                Arrays.sort(out);
                return inPlace ? victim : new Bytes(out, victim);
            }
            List<Byte> list = victim.toList();
            Collections.sort(list, this.comparator);
            return Bytes.from(list);
        }
    }

    public static final class ReverseTransformer
    implements BytesTransformer {
        @Override
        public Bytes transform(Bytes victim, boolean inPlace) {
            byte[] out = inPlace ? victim.internalArray() : victim.copy().internalArray();
            for (int i = 0; i < out.length / 2; ++i) {
                byte temp = out[i];
                out[i] = out[out.length - i - 1];
                out[out.length - i - 1] = temp;
            }
            return inPlace ? victim : new Bytes(out, victim);
        }
    }

    public static final class ConcatTransformer
    implements BytesTransformer {
        private final byte[] secondArray;

        public ConcatTransformer(byte[] secondArrays) {
            Objects.requireNonNull(secondArrays, "the second byte array must not be null");
            this.secondArray = secondArrays;
        }

        @Override
        public Bytes transform(Bytes victim, boolean inPlace) {
            return Bytes.wrap(Util.concat(victim.internalArray(), this.secondArray));
        }
    }

    public static final class ShiftTransformer
    implements BytesTransformer {
        private final int shiftCount;
        private final Type type;

        public ShiftTransformer(int shiftCount, Type type) {
            Objects.requireNonNull(type, "passed shift type must not be null");
            this.shiftCount = shiftCount;
            this.type = type;
        }

        @Override
        public Bytes transform(Bytes victim, boolean inPlace) {
            BigInteger bigInt = inPlace ? new BigInteger(victim.internalArray()) : new BigInteger(victim.copy().internalArray());
            switch (this.type) {
                case LEFT_SHIFT: {
                    return Bytes.wrap(bigInt.shiftLeft(this.shiftCount).toByteArray());
                }
                case RIGHT_SHIFT: {
                    return Bytes.wrap(bigInt.shiftRight(this.shiftCount).toByteArray());
                }
            }
            throw new IllegalArgumentException("unknown shift type " + (Object)((Object)this.type));
        }

        static enum Type {
            LEFT_SHIFT,
            RIGHT_SHIFT;

        }
    }

    public static final class NegateTransformer
    implements BytesTransformer {
        @Override
        public Bytes transform(Bytes victim, boolean inPlace) {
            byte[] out = inPlace ? victim.internalArray() : victim.copy().internalArray();
            for (int i = 0; i < victim.length(); ++i) {
                out[i] = ~out[i];
            }
            return inPlace ? victim : new Bytes(out, victim);
        }
    }

    public static final class BitWiseOperatorTransformer
    implements BytesTransformer {
        private final byte[] secondArray;
        private final Mode mode;

        public BitWiseOperatorTransformer(byte[] secondArray, Mode mode) {
            Objects.requireNonNull(secondArray, "the second byte array must not be null");
            Objects.requireNonNull(mode, "passed bitwise mode must not be null");
            this.secondArray = secondArray;
            this.mode = mode;
        }

        @Override
        public Bytes transform(Bytes victim, boolean inPlace) {
            if (victim.length() != this.secondArray.length) {
                throw new IllegalArgumentException("all byte array must be of same length doing bit wise operation");
            }
            byte[] out = inPlace ? victim.internalArray() : new byte[victim.length()];
            block5: for (int i = 0; i < victim.length(); ++i) {
                switch (this.mode) {
                    case OR: {
                        out[i] = (byte)(victim.internalArray()[i] | this.secondArray[i]);
                        continue block5;
                    }
                    case AND: {
                        out[i] = (byte)(victim.internalArray()[i] & this.secondArray[i]);
                        continue block5;
                    }
                    case XOR: {
                        out[i] = (byte)(victim.internalArray()[i] ^ this.secondArray[i]);
                        continue block5;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown bitwise transform mode " + (Object)((Object)this.mode));
                    }
                }
            }
            return inPlace ? victim : new Bytes(out, victim);
        }

        static enum Mode {
            AND,
            OR,
            XOR;

        }
    }
}

