/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.bytes;

import at.favre.lib.bytes.Bytes;
import java.nio.ByteOrder;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Objects;

public final class MutableBytes
extends Bytes {
    MutableBytes(byte[] byteArray, ByteOrder byteOrder) {
        super(byteArray, byteOrder, true, false);
    }

    public MutableBytes overwrite(byte[] newArray) {
        this.overwrite(newArray, 0);
        return this;
    }

    public MutableBytes overwrite(byte[] newArray, int offsetInternalArray) {
        Objects.requireNonNull(newArray, "must provide non-null array as source");
        System.arraycopy(newArray, 0, this.internalArray(), offsetInternalArray, newArray.length);
        return this;
    }

    public MutableBytes wipe() {
        this.fill((byte)0);
        return this;
    }

    public MutableBytes fill(byte fillByte) {
        Arrays.fill(this.internalArray(), fillByte);
        return this;
    }

    public MutableBytes secureWipe() {
        this.secureWipe(new SecureRandom());
        return this;
    }

    public MutableBytes secureWipe(SecureRandom random) {
        Objects.requireNonNull(random, "must non-null random");
        random.nextBytes(this.internalArray());
        return this;
    }
}

