/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.crypto.bkdf;

import at.favre.lib.crypto.HKDF;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public interface Version {
    public static final Version HKDF_HMAC512 = new Default(HKDF.fromHmacSha512(), true, 1);
    public static final Version HKDF_HMAC512_BCRYPT_24_BYTE = new Default(HKDF.fromHmacSha512(), false, 2);
    public static final List<Version> VERSIONS = Collections.unmodifiableList(Arrays.asList(HKDF_HMAC512, HKDF_HMAC512_BCRYPT_24_BYTE));

    public byte getVersionCode();

    public HKDF getHkdf();

    public boolean isUseOnly23ByteBcryptOut();

    public static class UnsupportedBkdfVersionException
    extends IllegalStateException {
        private final int unsupportedByte;

        public UnsupportedBkdfVersionException(int unsupportedByte) {
            this.unsupportedByte = unsupportedByte;
        }

        @Override
        public String getMessage() {
            return String.format("Version %d is not supported in this implementation of BKDF", this.unsupportedByte);
        }
    }

    public static final class Default
    implements Version {
        private final HKDF hkdf;
        private final boolean useOnly23ByteBcryptOut;
        private final byte versionCode;

        public Default(HKDF hkdf, boolean useOnly23ByteBcryptOut, byte versionCode) {
            this.hkdf = hkdf;
            this.useOnly23ByteBcryptOut = useOnly23ByteBcryptOut;
            this.versionCode = versionCode;
        }

        @Override
        public HKDF getHkdf() {
            return this.hkdf;
        }

        @Override
        public boolean isUseOnly23ByteBcryptOut() {
            return this.useOnly23ByteBcryptOut;
        }

        @Override
        public byte getVersionCode() {
            return this.versionCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Default aDefault = (Default)o;
            return this.useOnly23ByteBcryptOut == aDefault.useOnly23ByteBcryptOut && this.versionCode == aDefault.versionCode && Objects.equals(this.hkdf, aDefault.hkdf);
        }

        public int hashCode() {
            return Objects.hash(this.hkdf, this.useOnly23ByteBcryptOut, this.versionCode);
        }
    }

    public static final class Util {
        private Util() {
        }

        public static Version getByCode(byte versionCode) {
            for (Version version : VERSIONS) {
                if (version.getVersionCode() != versionCode) continue;
                return version;
            }
            throw new UnsupportedBkdfVersionException(versionCode);
        }
    }
}

