/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.crypto.bkdf;

import at.favre.lib.bytes.Bytes;
import at.favre.lib.bytes.BytesValidator;
import at.favre.lib.bytes.BytesValidators;
import at.favre.lib.crypto.bcrypt.BCrypt;
import at.favre.lib.crypto.bkdf.Version;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;

public interface PasswordHasher {
    public String hash(char[] var1, int var2);

    public HashData hashRaw(char[] var1, int var2);

    public static final class HashData {
        public final byte cost;
        public final Version version;
        public final byte[] rawSalt;
        public final byte[] rawHash;

        public HashData(byte cost, Version version, byte[] rawSalt, byte[] rawHash) {
            Objects.requireNonNull(rawHash);
            Objects.requireNonNull(rawSalt);
            Objects.requireNonNull(version);
            if (!Bytes.wrap((byte[])rawSalt).validate(new BytesValidator[]{BytesValidators.exactLength((int)16)}) || !Bytes.wrap((byte[])rawHash).validate(new BytesValidator[]{BytesValidators.or((BytesValidator[])new BytesValidator[]{BytesValidators.exactLength((int)23), BytesValidators.exactLength((int)24)})})) {
                throw new IllegalArgumentException("salt must be exactly 16 bytes and hash 23/24 bytes long");
            }
            this.cost = cost;
            this.version = version;
            this.rawSalt = rawSalt;
            this.rawHash = rawHash;
        }

        public byte[] getAsBlobMessageFormat() {
            if (this.rawHash == null) {
                throw new IllegalStateException("cannot reuse wiped instance");
            }
            ByteBuffer buffer = ByteBuffer.allocate(2 + this.rawSalt.length + this.rawHash.length);
            buffer.put(this.version.getVersionCode());
            buffer.put(this.cost);
            buffer.put(this.rawSalt);
            buffer.put(this.rawHash);
            return buffer.array();
        }

        public String getAsEncodedMessageFormat() {
            return Bytes.wrap((byte[])this.getAsBlobMessageFormat()).encodeBase64Url();
        }

        public void wipe() {
            Bytes.wrapNullSafe((byte[])this.rawSalt).mutable().secureWipe();
            Bytes.wrapNullSafe((byte[])this.rawHash).mutable().secureWipe();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HashData hashData = (HashData)o;
            return this.cost == hashData.cost && Objects.equals(this.version, hashData.version) && Bytes.wrapNullSafe((byte[])this.rawSalt).equalsConstantTime(hashData.rawSalt) && Bytes.wrapNullSafe((byte[])this.rawHash).equalsConstantTime(hashData.rawHash);
        }

        public int hashCode() {
            int result = Objects.hash(this.cost, this.version);
            result = 31 * result + Arrays.hashCode(this.rawSalt);
            result = 31 * result + Arrays.hashCode(this.rawHash);
            return result;
        }
    }

    public static final class Default
    implements PasswordHasher {
        private final SecureRandom secureRandom;
        private final Version version;

        Default(Version version, SecureRandom secureRandom) {
            this.version = version;
            this.secureRandom = secureRandom;
        }

        @Override
        public String hash(char[] password, int costFactor) {
            return this.hashRaw(password, costFactor).getAsEncodedMessageFormat();
        }

        @Override
        public HashData hashRaw(char[] password, int costFactor) {
            byte[] salt16Byte = Bytes.random((int)16, (Random)this.secureRandom).array();
            return this.hashRaw(password, salt16Byte, costFactor);
        }

        HashData hashRaw(char[] password, byte[] salt16Byte, int costFactor) {
            if (salt16Byte == null || salt16Byte.length < 16) {
                throw new IllegalArgumentException("invalid salt");
            }
            if (costFactor < 4 || costFactor > 31) {
                throw new IllegalArgumentException("cost-factor must be between 4 and 31 (same as for bcrypt itself)");
            }
            byte[] pwBytes = Bytes.from((char[])password, (Charset)StandardCharsets.UTF_8).array();
            byte[] extractedPw = this.version.getHkdf().extract(null, pwBytes);
            BCrypt.HashData data = BCrypt.with((BCrypt.Version)new BCrypt.Version(new byte[]{50, 97}, this.version.isUseOnly23ByteBcryptOut(), true, null, null)).hashRaw(costFactor, salt16Byte, extractedPw);
            return new HashData((byte)costFactor, this.version, salt16Byte, data.rawHash);
        }
    }
}

