/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.crypto.bkdf;

import at.favre.lib.bytes.Bytes;
import at.favre.lib.crypto.bkdf.BKDF;
import at.favre.lib.crypto.bkdf.PasswordHasher;
import at.favre.lib.crypto.bkdf.Version;
import java.nio.ByteBuffer;

public interface PasswordHashVerifier {
    public boolean verify(char[] var1, String var2);

    public boolean verify(char[] var1, PasswordHasher.HashData var2);

    public static final class Default
    implements PasswordHashVerifier {
        @Override
        public boolean verify(char[] password, String bkdfRefenceHash) {
            PasswordHasher.HashData hashData = this.parse(bkdfRefenceHash);
            return this.verify(password, hashData);
        }

        private PasswordHasher.HashData parse(String bkdfRefenceHash) {
            ByteBuffer buffer = Bytes.parseBase64((CharSequence)bkdfRefenceHash).buffer();
            byte versionByte = buffer.get();
            Version version = Version.Util.getByCode(versionByte);
            byte costFactor = buffer.get();
            byte[] salt = new byte[16];
            byte[] hash = new byte[version.isUseOnly23ByteBcryptOut() ? 23 : 24];
            buffer.get(salt);
            buffer.get(hash);
            return new PasswordHasher.HashData(costFactor, version, salt, hash);
        }

        @Override
        public boolean verify(char[] password, PasswordHasher.HashData bkdfPasswordHashFormat1) {
            PasswordHasher hasher = BKDF.createPasswordHasher(bkdfPasswordHashFormat1.version);
            PasswordHasher.HashData referenceHash = ((PasswordHasher.Default)hasher).hashRaw(password, bkdfPasswordHashFormat1.rawSalt, bkdfPasswordHashFormat1.cost);
            return Bytes.wrap((byte[])referenceHash.rawHash).equalsConstantTime(bkdfPasswordHashFormat1.rawHash);
        }
    }
}

