/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.crypto.bkdf;

import at.favre.lib.bytes.Bytes;
import at.favre.lib.crypto.HKDF;
import at.favre.lib.crypto.bcrypt.BCrypt;
import at.favre.lib.crypto.bkdf.Version;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public interface KeyDerivationFunction {
    public byte[] derive(byte[] var1, char[] var2, int var3, byte[] var4, int var5);

    public byte[] derive(byte[] var1, byte[] var2, int var3, byte[] var4, int var5);

    public static class Default
    implements KeyDerivationFunction {
        private static final byte[] FIXED_INFO_PARAM = Bytes.from((CharSequence)"bkdf").array();
        private final HKDF hkdf;
        private final boolean useOnly23ByteBcryptOut;

        public Default(Version version) {
            this.hkdf = version.getHkdf();
            this.useOnly23ByteBcryptOut = version.isUseOnly23ByteBcryptOut();
        }

        @Override
        public byte[] derive(byte[] salt, char[] password, int costFactor, byte[] infoParam, int outLengthByte) {
            return this.derive(salt, Bytes.from((char[])password, (Charset)StandardCharsets.UTF_8).array(), costFactor, infoParam, outLengthByte);
        }

        @Override
        public byte[] derive(byte[] salt, byte[] ikm, int costFactor, byte[] infoParam, int outLengthByte) {
            byte[] extractedPw = this.hkdf.extract(null, ikm);
            BCrypt.HashData data = BCrypt.with((BCrypt.Version)new BCrypt.Version(new byte[]{50, 97}, this.useOnly23ByteBcryptOut, true, null, null)).hashRaw(costFactor, salt, extractedPw);
            return this.hkdf.expand(data.rawHash, Bytes.wrapNullSafe((byte[])infoParam).append(FIXED_INFO_PARAM).array(), outLengthByte);
        }
    }
}

