/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.crypto.bkdf;

import at.favre.lib.crypto.bkdf.KeyDerivationFunction;
import at.favre.lib.crypto.bkdf.PasswordHashVerifier;
import at.favre.lib.crypto.bkdf.PasswordHasher;
import at.favre.lib.crypto.bkdf.Version;
import java.security.SecureRandom;

public final class BKDF {
    private BKDF() {
    }

    public static PasswordHasher createPasswordHasher() {
        return BKDF.createPasswordHasher(Version.HKDF_HMAC512_BCRYPT_24_BYTE, new SecureRandom());
    }

    public static PasswordHasher createPasswordHasher(Version version) {
        return BKDF.createPasswordHasher(version, new SecureRandom());
    }

    public static PasswordHasher createPasswordHasher(Version version, SecureRandom secureRandom) {
        return new PasswordHasher.Default(version, secureRandom);
    }

    public static PasswordHashVerifier createPasswordHashVerifier() {
        return new PasswordHashVerifier.Default();
    }

    public static KeyDerivationFunction createKdf(Version version) {
        return new KeyDerivationFunction.Default(version);
    }

    public static KeyDerivationFunction createKdf() {
        return BKDF.createKdf(Version.HKDF_HMAC512_BCRYPT_24_BYTE);
    }
}

