/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.crypto.bkdf;

import at.favre.lib.bytes.Bytes;
import at.favre.lib.crypto.HKDF;
import at.favre.lib.crypto.bcrypt.BCrypt;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public interface KeyDerivationFunction {
    public byte[] derive(byte[] var1, char[] var2, int var3, byte[] var4, int var5);

    public byte[] derive(byte[] var1, byte[] var2, int var3, byte[] var4, int var5);

    public static class Default
    implements KeyDerivationFunction {
        private final HKDF hkdf;
        private final boolean useOnly23ByteBcryptOut;

        public Default(HKDF hkdf, boolean useOnly23ByteBcryptOut) {
            this.hkdf = hkdf;
            this.useOnly23ByteBcryptOut = useOnly23ByteBcryptOut;
        }

        @Override
        public byte[] derive(byte[] salt, char[] password, int logRounds, byte[] infoParam, int outLengthByte) {
            return this.derive(salt, Bytes.from((char[])password, (Charset)StandardCharsets.UTF_8).array(), logRounds, infoParam, outLengthByte);
        }

        @Override
        public byte[] derive(byte[] salt, byte[] ikm, int logRounds, byte[] infoParam, int outLengthByte) {
            byte[] extractedPw = this.hkdf.extract(null, ikm);
            BCrypt.HashData data = BCrypt.with((BCrypt.Version)new BCrypt.Version(new byte[]{2, 0}, this.useOnly23ByteBcryptOut, true, null, null)).hashRaw(logRounds, salt, extractedPw);
            return this.hkdf.expand(data.rawHash, Bytes.from((CharSequence)"bkdf").append(infoParam).array(), outLengthByte);
        }
    }
}

