/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.crypto.bcrypt;

import at.favre.lib.bytes.Bytes;
import at.favre.lib.bytes.BytesTransformer;

public interface LongPasswordStrategy {
    public byte[] derive(byte[] var1);

    public static final class TruncateStrategy
    extends BaseLongPasswordStrategy {
        TruncateStrategy() {
        }

        @Override
        public final byte[] innerDerive(byte[] rawPassword) {
            return Bytes.wrap((byte[])rawPassword).resize(this.maxLength, BytesTransformer.ResizeTransformer.Mode.RESIZE_KEEP_FROM_ZERO_INDEX).array();
        }
    }

    public static final class Sha512DerivationStrategy
    extends BaseLongPasswordStrategy {
        Sha512DerivationStrategy() {
        }

        @Override
        public final byte[] innerDerive(byte[] rawPassword) {
            return Bytes.wrap((byte[])rawPassword).hash("SHA-512").array();
        }
    }

    public static final class StrictMaxPasswordLengthStrategy
    extends BaseLongPasswordStrategy {
        StrictMaxPasswordLengthStrategy() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte[] innerDerive(byte[] rawPassword) {
            void var1_1;
            throw new IllegalArgumentException("password must not be longer than " + this.maxLength + " bytes plus null terminator encoded in utf-8, was " + ((void)var1_1).length);
        }
    }

    public static abstract class BaseLongPasswordStrategy
    implements LongPasswordStrategy {
        final int maxLength;

        private BaseLongPasswordStrategy(int maxLength) {
            this.maxLength = 71;
        }

        abstract byte[] innerDerive(byte[] var1);

        /*
         * WARNING - void declaration
         */
        @Override
        public byte[] derive(byte[] rawPassword) {
            void var1_1;
            if (rawPassword.length >= this.maxLength) {
                return this.innerDerive(rawPassword);
            }
            return var1_1;
        }

        /* synthetic */ BaseLongPasswordStrategy() {
            this(71);
        }
    }
}

