/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.crypto.bcrypt;

import at.favre.lib.bytes.Bytes;
import at.favre.lib.crypto.bcrypt.BCrypt;
import at.favre.lib.crypto.bcrypt.Radix64Encoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Locale;

public interface BCryptFormatter {
    public byte[] createHashMessage(BCrypt.HashData var1);

    public static final class Default
    implements BCryptFormatter {
        private final Radix64Encoder encoder;
        private final Charset defaultCharset;

        /*
         * WARNING - void declaration
         */
        public Default(Radix64Encoder encoder, Charset defaultCharset) {
            void var2_2;
            void var1_1;
            this.encoder = var1_1;
            this.defaultCharset = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte[] createHashMessage(BCrypt.HashData hashData) {
            byte[] byArray;
            byte[] saltEncoded = this.encoder.encode(hashData.rawSalt);
            byte[] hashEncoded = this.encoder.encode(hashData.rawHash);
            byte[] costFactorBytes = String.format(Locale.US, "%02d", hashData.cost).getBytes(this.defaultCharset);
            try {
                ByteBuffer byteBuffer = ByteBuffer.allocate(hashData.version.versionIdentifier.length + costFactorBytes.length + 3 + saltEncoded.length + hashEncoded.length);
                byteBuffer.put((byte)36);
                byteBuffer.put(byArray.version.versionIdentifier);
                byteBuffer.put((byte)36);
                byteBuffer.put(costFactorBytes);
                byteBuffer.put((byte)36);
                byteBuffer.put(saltEncoded);
                byteBuffer.put(hashEncoded);
                byArray = byteBuffer.array();
            }
            catch (Throwable throwable) {
                void var3_4;
                void var2_3;
                Bytes.wrapNullSafe((byte[])var2_3).mutable().secureWipe();
                Bytes.wrapNullSafe((byte[])var3_4).mutable().secureWipe();
                Bytes.wrapNullSafe((byte[])costFactorBytes).mutable().secureWipe();
                throw throwable;
            }
            Bytes.wrapNullSafe((byte[])saltEncoded).mutable().secureWipe();
            Bytes.wrapNullSafe((byte[])hashEncoded).mutable().secureWipe();
            Bytes.wrapNullSafe((byte[])costFactorBytes).mutable().secureWipe();
            return byArray;
        }
    }
}

