/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.crypto.bcrypt;

import at.favre.lib.bytes.Bytes;
import at.favre.lib.bytes.BytesTransformer;
import at.favre.lib.bytes.BytesValidator;
import at.favre.lib.bytes.BytesValidators;
import at.favre.lib.crypto.bcrypt.BCryptFormatter;
import at.favre.lib.crypto.bcrypt.BCryptOpenBSDProtocol;
import at.favre.lib.crypto.bcrypt.BCryptParser;
import at.favre.lib.crypto.bcrypt.IllegalBCryptFormatException;
import at.favre.lib.crypto.bcrypt.LongPasswordStrategy;
import at.favre.lib.crypto.bcrypt.Radix64Encoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;

public final class BCrypt {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final int SALT_LENGTH = 16;
    public static final int MAX_PW_LENGTH_BYTE = 71;
    public static final int MIN_COST = 4;
    public static final int MAX_COST = 31;

    private BCrypt() {
    }

    public static Hasher withDefaults() {
        return new Hasher(Version.VERSION_2A, new SecureRandom(), new LongPasswordStrategy.StrictMaxPasswordLengthStrategy(), 0);
    }

    public static Hasher with(Version version) {
        Version version2;
        return new Hasher(version2, new SecureRandom(), new LongPasswordStrategy.StrictMaxPasswordLengthStrategy(), 0);
    }

    public static Hasher with(SecureRandom secureRandom) {
        SecureRandom secureRandom2;
        return new Hasher(Version.VERSION_2A, secureRandom2, new LongPasswordStrategy.StrictMaxPasswordLengthStrategy(), 0);
    }

    public static Hasher with(LongPasswordStrategy longPasswordStrategy) {
        LongPasswordStrategy longPasswordStrategy2;
        return new Hasher(Version.VERSION_2A, new SecureRandom(), longPasswordStrategy2, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static Hasher with(Version version, SecureRandom secureRandom, LongPasswordStrategy longPasswordStrategy) {
        void var2_2;
        void var1_1;
        Version version2;
        return new Hasher(version2, (SecureRandom)var1_1, (LongPasswordStrategy)var2_2, 0);
    }

    public static Verifyer verifyer() {
        return new Verifyer(0);
    }

    static /* synthetic */ Charset access$200() {
        return DEFAULT_CHARSET;
    }

    static /* synthetic */ byte[] access$300(char[] x0, Charset x1) {
        Object object;
        ByteBuffer byteBuffer = x1.encode(CharBuffer.wrap((char[])object));
        object = byteBuffer;
        byte[] byArray = new byte[byteBuffer.remaining()];
        ((ByteBuffer)object).get(byArray);
        return byArray;
    }

    public static final class Version {
        private static final BCryptFormatter DEFAULT_FORMATTER = new BCryptFormatter.Default(new Radix64Encoder.Default(), BCrypt.access$200());
        private static final BCryptParser DEFAULT_PARSER = new BCryptParser.Default(new Radix64Encoder.Default(), BCrypt.access$200());
        public static final Version VERSION_2A = new Version(new byte[]{50, 97}, DEFAULT_FORMATTER, DEFAULT_PARSER);
        public static final Version VERSION_2B = new Version(new byte[]{50, 98}, DEFAULT_FORMATTER, DEFAULT_PARSER);
        public static final Version VERSION_2X = new Version(new byte[]{50, 120}, DEFAULT_FORMATTER, DEFAULT_PARSER);
        public static final Version VERSION_2Y = new Version(new byte[]{50, 121}, DEFAULT_FORMATTER, DEFAULT_PARSER);
        public static final Version VERSION_BC = new Version(new byte[]{50, 99}, false, false, DEFAULT_FORMATTER, DEFAULT_PARSER);
        public static final List<Version> SUPPORTED_VERSIONS = Collections.unmodifiableList(Arrays.asList(VERSION_2A, VERSION_2B, VERSION_2X, VERSION_2Y));
        public final byte[] versionIdentifier;
        public final boolean useOnly23bytesForHash;
        public final boolean appendNullTerminator;
        public final BCryptFormatter formatter;
        public final BCryptParser parser;

        /*
         * WARNING - void declaration
         */
        private Version(byte[] versionIdentifier, BCryptFormatter formatter, BCryptParser parser) {
            this((byte[])var1_1, true, true, (BCryptFormatter)var2_2, (BCryptParser)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Version(byte[] versionIdentifier, boolean useOnly23bytesForHash, boolean appendNullTerminator, BCryptFormatter formatter, BCryptParser parser) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.versionIdentifier = var1_1;
            this.useOnly23bytesForHash = var2_2;
            this.appendNullTerminator = var3_3;
            this.formatter = formatter;
            this.parser = parser;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object o) {
            void var1_1;
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Version version = (Version)o;
            return this.useOnly23bytesForHash == version.useOnly23bytesForHash && this.appendNullTerminator == version.appendNullTerminator && Arrays.equals(this.versionIdentifier, var1_1.versionIdentifier);
        }

        /*
         * WARNING - void declaration
         */
        public final int hashCode() {
            void var1_1;
            int result = Objects.hash(this.useOnly23bytesForHash, this.appendNullTerminator);
            return 31 * var1_1 + Arrays.hashCode(this.versionIdentifier);
        }

        public final String toString() {
            return "$" + new String(this.versionIdentifier) + "$";
        }
    }

    public static final class Result {
        public final HashData details;
        public final boolean validFormat;
        public final boolean verified;
        public final String formatErrorMessage;

        /*
         * WARNING - void declaration
         */
        Result(IllegalBCryptFormatException e) {
            this(null, false, false, var1_1.getMessage());
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        Result(HashData details, boolean verified) {
            this((HashData)var1_1, true, (boolean)var2_2, null);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private Result(HashData details, boolean validFormat, boolean verified, String formatErrorMessage) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.details = var1_1;
            this.validFormat = var2_2;
            this.verified = var3_3;
            this.formatErrorMessage = formatErrorMessage;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object o) {
            void var1_1;
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result result = (Result)o;
            return this.validFormat == result.validFormat && this.verified == result.verified && Objects.equals(this.details, result.details) && Objects.equals(this.formatErrorMessage, var1_1.formatErrorMessage);
        }

        public final int hashCode() {
            return Objects.hash(this.details, this.validFormat, this.verified, this.formatErrorMessage);
        }

        public final String toString() {
            return "Result{details=" + this.details + ", validFormat=" + this.validFormat + ", verified=" + this.verified + ", formatErrorMessage='" + this.formatErrorMessage + '\'' + '}';
        }
    }

    public static final class Verifyer {
        private final Charset defaultCharset = BCrypt.access$200();

        private Verifyer() {
        }

        /*
         * WARNING - void declaration
         */
        public final Result verifyStrict(byte[] password, byte[] bcryptHash, Version expectedVersion) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.verify((byte[])var1_1, (byte[])var2_2, (Version)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        public final Result verify(byte[] password, byte[] bcryptHash) {
            void var2_2;
            void var1_1;
            return this.verify((byte[])var1_1, (byte[])var2_2, null);
        }

        /*
         * WARNING - void declaration
         */
        public final Result verifyStrict(char[] password, char[] bcryptHash, Version expectedVersion) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.verify((char[])var1_1, (char[])var2_2, (Version)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        public final Result verify(char[] password, char[] bcryptHash) {
            void var2_2;
            void var1_1;
            return this.verify((char[])var1_1, (char[])var2_2, null);
        }

        public final Result verify(char[] password, CharSequence bcryptHash) {
            char[] cArray;
            char[] cArray2;
            char[] cArray3;
            void v0 = cArray3;
            cArray3 = cArray2;
            if (cArray3 instanceof String) {
                cArray = cArray3.toString().toCharArray();
            } else {
                cArray2 = new char[cArray3.length()];
                for (int i = 0; i < cArray3.length(); ++i) {
                    cArray2[i] = cArray3.charAt(i);
                }
                cArray = cArray2;
            }
            return this.verify((char[])v0, cArray, null);
        }

        /*
         * WARNING - void declaration
         */
        private Result verify(char[] password, char[] bcryptHash, Version requiredVersion) {
            Result result;
            byte[] passwordBytes = null;
            byte[] bcryptHashBytes = null;
            try {
                void var3_4;
                void var2_3;
                passwordBytes = BCrypt.access$300((char[])result, this.defaultCharset);
                bcryptHashBytes = BCrypt.access$300((char[])var2_3, this.defaultCharset);
                result = this.verify(passwordBytes, bcryptHashBytes, (Version)var3_4);
            }
            catch (Throwable throwable) {
                Bytes.wrapNullSafe(passwordBytes).mutable().secureWipe();
                Bytes.wrapNullSafe(bcryptHashBytes).mutable().secureWipe();
                throw throwable;
            }
            Bytes.wrapNullSafe((byte[])passwordBytes).mutable().secureWipe();
            Bytes.wrapNullSafe((byte[])bcryptHashBytes).mutable().secureWipe();
            return result;
        }

        /*
         * WARNING - void declaration
         */
        private Result verify(byte[] password, byte[] bcryptHash, Version requiredVersion) {
            Objects.requireNonNull(bcryptHash);
            BCryptParser parser = requiredVersion == null ? Version.VERSION_2A.parser : requiredVersion.parser;
            try {
                void var1_1;
                void var3_4;
                HashData hashData = parser.parse(bcryptHash);
                if (requiredVersion != null && hashData.version != var3_4) {
                    return new Result(hashData, false);
                }
                return this.verify((byte[])var1_1, hashData.cost, hashData.rawSalt, hashData.rawHash);
            }
            catch (IllegalBCryptFormatException e) {
                void var2_3;
                return new Result((IllegalBCryptFormatException)var2_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final Result verify(byte[] password, HashData bcryptHashData) {
            void var2_2;
            void var1_1;
            return this.verify((byte[])var1_1, bcryptHashData.cost, bcryptHashData.rawSalt, var2_2.rawHash);
        }

        /*
         * WARNING - void declaration
         */
        public final Result verify(byte[] password, int cost, byte[] salt, byte[] rawBcryptHash23Bytes) {
            void var1_1;
            void var3_3;
            void var2_2;
            Objects.requireNonNull(password);
            Objects.requireNonNull(rawBcryptHash23Bytes);
            Objects.requireNonNull(salt);
            HashData hashData = BCrypt.withDefaults().hashRaw((int)var2_2, (byte[])var3_3, password);
            void v0 = var1_1;
            return new Result((HashData)v0, MessageDigest.isEqual(v0.rawHash, rawBcryptHash23Bytes));
        }

        /* synthetic */ Verifyer(byte by) {
            this();
        }
    }

    public static final class HashData {
        public final int cost;
        public final Version version;
        public final byte[] rawSalt;
        public final byte[] rawHash;

        /*
         * WARNING - void declaration
         */
        public HashData(int cost, Version version, byte[] rawSalt, byte[] rawHash) {
            void var3_3;
            void var2_2;
            void var1_1;
            Objects.requireNonNull(rawHash);
            Objects.requireNonNull(rawSalt);
            Objects.requireNonNull(version);
            if (!Bytes.wrap((byte[])rawSalt).validate(new BytesValidator[]{BytesValidators.exactLength((int)16)}) || !Bytes.wrap((byte[])rawHash).validate(new BytesValidator[]{BytesValidators.or((BytesValidator[])new BytesValidator[]{BytesValidators.exactLength((int)23), BytesValidators.exactLength((int)24)})})) {
                throw new IllegalArgumentException("salt must be exactly 16 bytes and hash 23 bytes long");
            }
            this.cost = var1_1;
            this.version = var2_2;
            this.rawSalt = var3_3;
            this.rawHash = rawHash;
        }

        public final void wipe() {
            Bytes.wrapNullSafe((byte[])this.rawSalt).mutable().secureWipe();
            Bytes.wrapNullSafe((byte[])this.rawHash).mutable().secureWipe();
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object o) {
            void var1_1;
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HashData hashData = (HashData)o;
            return this.cost == hashData.cost && this.version == hashData.version && Bytes.wrap((byte[])this.rawSalt).equalsConstantTime(hashData.rawSalt) && Bytes.wrap((byte[])this.rawHash).equalsConstantTime(var1_1.rawHash);
        }

        /*
         * WARNING - void declaration
         */
        public final int hashCode() {
            void var1_1;
            int result = Objects.hash(this.cost, this.version);
            result = 31 * result + Arrays.hashCode(this.rawSalt);
            return 31 * var1_1 + Arrays.hashCode(this.rawHash);
        }

        public final String toString() {
            return "HashData{cost=" + this.cost + ", version=" + this.version + ", rawSalt=" + Bytes.wrap((byte[])this.rawSalt).encodeHex() + ", rawHash=" + Bytes.wrap((byte[])this.rawHash).encodeHex() + '}';
        }
    }

    public static final class Hasher {
        private final Charset defaultCharset = BCrypt.access$200();
        private final Version version;
        private final SecureRandom secureRandom;
        private final LongPasswordStrategy longPasswordStrategy;

        /*
         * WARNING - void declaration
         */
        private Hasher(Version version, SecureRandom secureRandom, LongPasswordStrategy longPasswordStrategy) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.version = var1_1;
            this.secureRandom = var2_2;
            this.longPasswordStrategy = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public final char[] hashToChar(int cost, char[] password) {
            void var2_2;
            void var1_1;
            return this.defaultCharset.decode(ByteBuffer.wrap(this.hash((int)var1_1, (char[])var2_2))).array();
        }

        /*
         * WARNING - void declaration
         */
        public final String hashToString(int cost, char[] password) {
            void var2_2;
            void var1_1;
            return new String(this.hash((int)var1_1, (char[])var2_2), this.defaultCharset);
        }

        /*
         * WARNING - void declaration
         */
        public final byte[] hash(int cost, char[] password) {
            byte[] byArray;
            if (password == null) {
                throw new IllegalArgumentException("provided password must not be null");
            }
            byte[] passwordBytes = null;
            try {
                void var1_1;
                void var2_4;
                passwordBytes = BCrypt.access$300((char[])var2_4, this.defaultCharset);
                byArray = this.hash((int)var1_1, Bytes.random((int)16, (Random)this.secureRandom).array(), passwordBytes);
            }
            catch (Throwable throwable) {
                void var3_5;
                Bytes.wrapNullSafe((byte[])var3_5).mutable().secureWipe();
                throw throwable;
            }
            Bytes.wrapNullSafe((byte[])passwordBytes).mutable().secureWipe();
            return byArray;
        }

        /*
         * WARNING - void declaration
         */
        public final byte[] hash(int cost, byte[] password) {
            void var2_2;
            void var1_1;
            return this.hash((int)var1_1, Bytes.random((int)16, (Random)this.secureRandom).array(), (byte[])var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final byte[] hash(int cost, byte[] salt, byte[] password) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.version.formatter.createHashMessage(this.hashRaw((int)var1_1, (byte[])var2_2, (byte[])var3_3));
        }

        /*
         * WARNING - void declaration
         */
        public final HashData hashRaw(int cost, byte[] salt, byte[] password) {
            HashData hashData;
            if (cost > 31 || cost < 4) {
                throw new IllegalArgumentException("cost factor must be between 4 and 31, was ".concat(String.valueOf(cost)));
            }
            if (salt == null) {
                throw new IllegalArgumentException("salt must not be null");
            }
            if (salt.length != 16) {
                throw new IllegalArgumentException("salt must be exactly 16 bytes, was " + salt.length);
            }
            if (password == null) {
                throw new IllegalArgumentException("provided password must not be null");
            }
            if (!this.version.appendNullTerminator && password.length == 0) {
                throw new IllegalArgumentException("provided password must at least be length 1 if no null terminator is appended");
            }
            if (password.length > 71 + (this.version.appendNullTerminator ? 0 : 1)) {
                password = this.longPasswordStrategy.derive(password);
            }
            byte[] pwWithNullTerminator = this.version.appendNullTerminator ? Bytes.wrap((byte[])password).append((byte)0).array() : Bytes.wrap((byte[])password).copy().array();
            try {
                void var2_4;
                void var1_1;
                new BCryptOpenBSDProtocol();
                byte[] hash = BCryptOpenBSDProtocol.cryptRaw(1L << (int)((long)cost), salt, pwWithNullTerminator);
                hashData = new HashData((int)var1_1, this.version, (byte[])var2_4, this.version.useOnly23bytesForHash ? Bytes.wrap((byte[])hash).resize(23, BytesTransformer.ResizeTransformer.Mode.RESIZE_KEEP_FROM_ZERO_INDEX).array() : hash);
            }
            catch (Throwable throwable) {
                void var3_5;
                Bytes.wrapNullSafe((byte[])var3_5).mutable().secureWipe();
                throw throwable;
            }
            Bytes.wrapNullSafe((byte[])pwWithNullTerminator).mutable().secureWipe();
            return hashData;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ Hasher(Version x0, SecureRandom x1, LongPasswordStrategy x2, byte by) {
            this((Version)var1_1, (SecureRandom)var2_2, (LongPasswordStrategy)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }
    }
}

