/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.crypto.bcrypt;

import at.favre.lib.bytes.Bytes;
import at.favre.lib.crypto.bcrypt.BCrypt;
import at.favre.lib.crypto.bcrypt.IllegalBCryptFormatException;
import at.favre.lib.crypto.bcrypt.Radix64Encoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public interface BCryptParser {
    public BCrypt.HashData parse(byte[] var1) throws IllegalBCryptFormatException;

    public static final class Default
    implements BCryptParser {
        private final Charset defaultCharset;
        private final Radix64Encoder encoder;

        /*
         * WARNING - void declaration
         */
        Default(Radix64Encoder encoder, Charset defaultCharset) {
            void var1_1;
            void var2_2;
            this.defaultCharset = var2_2;
            this.encoder = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final BCrypt.HashData parse(byte[] bcryptHash) throws IllegalBCryptFormatException {
            void var1_1;
            void var3_3;
            void var2_2;
            int parsedCostFactor;
            if (bcryptHash == null || bcryptHash.length == 0) {
                throw new IllegalArgumentException("must provide non-null, non-empty hash");
            }
            if (bcryptHash.length < 7) {
                throw new IllegalBCryptFormatException("hash prefix meta must be at least 7 bytes long e.g. '$2a$10$'");
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(bcryptHash);
            if (byteBuffer.get() != 36) {
                throw new IllegalBCryptFormatException("hash must start with " + Bytes.from((byte)36).encodeUtf8());
            }
            BCrypt.Version usedVersion = null;
            for (BCrypt.Version versionToTest : BCrypt.Version.SUPPORTED_VERSIONS) {
                for (int i = 0; i < versionToTest.versionIdentifier.length; ++i) {
                    if (byteBuffer.get() != versionToTest.versionIdentifier[i]) {
                        ByteBuffer byteBuffer2 = byteBuffer;
                        byteBuffer2.position(byteBuffer2.position() - (i + 1));
                        break;
                    }
                    if (i != versionToTest.versionIdentifier.length - 1) continue;
                    usedVersion = versionToTest;
                }
                if (usedVersion == null) continue;
            }
            if (usedVersion == null) {
                throw new IllegalBCryptFormatException("unknown bcrypt version");
            }
            if (byteBuffer.get() != 36) {
                throw new IllegalBCryptFormatException("expected separator " + Bytes.from((byte)36).encodeUtf8() + " after version identifier and before cost factor");
            }
            byte[] costBytes = new byte[]{byteBuffer.get(), byteBuffer.get()};
            try {
                parsedCostFactor = Integer.valueOf(new String(costBytes, this.defaultCharset));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalBCryptFormatException("cannot parse cost factor '" + new String(costBytes, this.defaultCharset) + "'");
            }
            if (byteBuffer.get() != 36) {
                throw new IllegalBCryptFormatException("expected separator " + Bytes.from((byte)36).encodeUtf8() + " after cost factor");
            }
            if (bcryptHash.length != 60) {
                throw new IllegalBCryptFormatException("hash expected to be exactly 60 bytes");
            }
            byte[] salt = new byte[22];
            byte[] hash = new byte[31];
            byteBuffer.get(salt);
            var2_2.get(hash);
            return new BCrypt.HashData(parsedCostFactor, (BCrypt.Version)var3_3, this.encoder.decode(salt), this.encoder.decode((byte[])var1_1));
        }
    }
}

