/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.crypto.bcrypt;

import java.util.Arrays;

public interface Radix64Encoder {
    public byte[] encode(byte[] var1);

    public byte[] decode(byte[] var1);

    public static final class Default
    implements Radix64Encoder {
        private static final char[] toBase64 = new char[]{'.', '/', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        private static final int[] fromBase64 = new int[256];

        private int outLength(int srclen) {
            int n = srclen % 3;
            return 4 * (srclen / 3) + (n == 0 ? 0 : n + 1);
        }

        private int encode0(byte[] src, int end, byte[] dst) {
            char[] base64 = toBase64;
            int sp = 0;
            int slen = end / 3 * 3;
            int dp = 0;
            while (sp < slen) {
                int sl0 = Math.min(sp + slen, slen);
                int sp0 = sp;
                int dp0 = dp;
                while (sp0 < sl0) {
                    int bits = (src[sp0++] & 0xFF) << 16 | (src[sp0++] & 0xFF) << 8 | src[sp0++] & 0xFF;
                    dst[dp0++] = (byte)base64[bits >>> 18 & 0x3F];
                    dst[dp0++] = (byte)base64[bits >>> 12 & 0x3F];
                    dst[dp0++] = (byte)base64[bits >>> 6 & 0x3F];
                    dst[dp0++] = (byte)base64[bits & 0x3F];
                }
                int dlen = (sl0 - sp) / 3 * 4;
                dp += dlen;
                sp = sl0;
            }
            if (sp < end) {
                int b0 = src[sp++] & 0xFF;
                dst[dp++] = (byte)base64[b0 >> 2];
                if (sp == end) {
                    dst[dp++] = (byte)base64[b0 << 4 & 0x3F];
                } else {
                    int b1 = src[sp++] & 0xFF;
                    dst[dp++] = (byte)base64[b0 << 4 & 0x3F | b1 >> 4];
                    dst[dp++] = (byte)base64[b1 << 2 & 0x3F];
                }
            }
            return dp;
        }

        @Override
        public byte[] encode(byte[] rawBytes) {
            int len = this.outLength(rawBytes.length);
            byte[] dst = new byte[len];
            int ret = this.encode0(rawBytes, rawBytes.length, dst);
            if (ret != dst.length) {
                return Arrays.copyOf(dst, ret);
            }
            return dst;
        }

        @Override
        public byte[] decode(byte[] src) {
            byte[] dst = new byte[this.outLengthDecode(src.length)];
            int ret = this.decode0(src, 0, src.length, dst);
            if (ret != dst.length) {
                dst = Arrays.copyOf(dst, ret);
            }
            return dst;
        }

        private int outLengthDecode(int len) {
            int paddings = 0;
            if (len == 0) {
                return 0;
            }
            if (len < 2) {
                throw new IllegalArgumentException("Input byte[] should at least have 2 bytes for radix64 bytes");
            }
            if ((len & 3) != 0) {
                paddings = 4 - (len & 3);
            }
            return 3 * ((len + 3) / 4) - paddings;
        }

        private int decode0(byte[] src, int sp, int sl, byte[] dst) {
            int dp = 0;
            int bits = 0;
            int shiftto = 18;
            while (sp < sl) {
                int b = src[sp++] & 0xFF;
                if ((b = fromBase64[b]) < 0) {
                    if (b == -2) {
                        if ((shiftto != 6 || sp != sl && src[sp++] == 61) && shiftto != 18) break;
                        throw new IllegalArgumentException("Input byte array has wrong 4-byte ending unit");
                    }
                    throw new IllegalArgumentException("Illegal base64 character " + Integer.toString(src[sp - 1], 16));
                }
                bits |= b << shiftto;
                if ((shiftto -= 6) >= 0) continue;
                dst[dp++] = (byte)(bits >> 16);
                dst[dp++] = (byte)(bits >> 8);
                dst[dp++] = (byte)bits;
                shiftto = 18;
                bits = 0;
            }
            if (shiftto == 6) {
                dst[dp++] = (byte)(bits >> 16);
            } else if (shiftto == 0) {
                dst[dp++] = (byte)(bits >> 16);
                dst[dp++] = (byte)(bits >> 8);
            } else if (shiftto == 12) {
                throw new IllegalArgumentException("Last unit does not have enough valid bits");
            }
            if (sp < sl) {
                throw new IllegalArgumentException("Input byte array has incorrect ending byte at " + sp);
            }
            return dp;
        }

        static {
            Arrays.fill(fromBase64, -1);
            for (int i = 0; i < toBase64.length; ++i) {
                Default.fromBase64[Default.toBase64[i]] = i;
            }
            Default.fromBase64[61] = -2;
        }
    }
}

