/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.crypto.bcrypt;

import java.io.ByteArrayOutputStream;

public interface Radix64Encoder {
    public byte[] encode(byte[] var1, int var2);

    public byte[] decode(byte[] var1);

    public static final class Default
    implements Radix64Encoder {
        private static final char[] BCRYPT_RADIX64_CODE = new char[]{'.', '/', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        private static final byte[] INDEX_64 = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, -1, -1, -1, -1, -1, -1, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, -1, -1, -1, -1, -1};

        @Override
        public byte[] encode(byte[] rawBytes, int maxLengthToEncode) {
            int off = 0;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            if (maxLengthToEncode <= 0 || maxLengthToEncode > rawBytes.length) {
                throw new IllegalArgumentException("invalid max length, must be greater 0 and smaller than input length");
            }
            while (off < maxLengthToEncode) {
                int c1 = rawBytes[off++] & 0xFF;
                bos.write(BCRYPT_RADIX64_CODE[c1 >> 2 & 0x3F]);
                c1 = (c1 & 3) << 4;
                if (off >= maxLengthToEncode) {
                    bos.write(BCRYPT_RADIX64_CODE[c1 & 0x3F]);
                    break;
                }
                int c2 = rawBytes[off++] & 0xFF;
                bos.write(BCRYPT_RADIX64_CODE[(c1 |= c2 >> 4 & 0xF) & 0x3F]);
                c1 = (c2 & 0xF) << 2;
                if (off >= maxLengthToEncode) {
                    bos.write(BCRYPT_RADIX64_CODE[c1 & 0x3F]);
                    break;
                }
                c2 = rawBytes[off++] & 0xFF;
                bos.write(BCRYPT_RADIX64_CODE[(c1 |= c2 >> 6 & 3) & 0x3F]);
                bos.write(BCRYPT_RADIX64_CODE[c2 & 0x3F]);
            }
            return bos.toByteArray();
        }

        private static byte char64(byte x) {
            if (x >= INDEX_64.length) {
                return -1;
            }
            return INDEX_64[x];
        }

        @Override
        public byte[] decode(byte[] utf8EncodedBytes) {
            return this.decode(utf8EncodedBytes, utf8EncodedBytes.length);
        }

        private byte[] decode(byte[] utf8EncodedBytes, int maxLen) {
            if (utf8EncodedBytes.length == 0) {
                return new byte[0];
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int off = 0;
            int slen = utf8EncodedBytes.length;
            for (int olen = 0; off < slen - 1 && olen < maxLen; ++olen) {
                byte c3;
                byte c1 = Default.char64(utf8EncodedBytes[off++]);
                byte c2 = Default.char64(utf8EncodedBytes[off++]);
                if (c1 == -1 || c2 == -1) break;
                byte o = (byte)(c1 << 2);
                o = (byte)(o | (c2 & 0x30) >> 4);
                bos.write(o);
                if (++olen >= maxLen || off >= slen || (c3 = Default.char64(utf8EncodedBytes[off++])) == -1) break;
                o = (byte)((c2 & 0xF) << 4);
                o = (byte)(o | (c3 & 0x3C) >> 2);
                bos.write(o);
                if (++olen >= maxLen || off >= slen) break;
                byte c4 = Default.char64(utf8EncodedBytes[off++]);
                o = (byte)((c3 & 3) << 6);
                o = (byte)(o | c4);
                bos.write(o);
            }
            return bos.toByteArray();
        }
    }
}

