/*
 * Decompiled with CFR 0.152.
 */
package com.github.fedy2.weather.binding.adapter;

import com.github.fedy2.weather.data.unit.SpeedUnit;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeedUnitAdapter
extends XmlAdapter<String, SpeedUnit> {
    private static final String KMH = "km/h";
    private static final String MPH = "mph";
    private Logger logger = LoggerFactory.getLogger(SpeedUnitAdapter.class);

    public SpeedUnit unmarshal(String v) throws Exception {
        if (MPH.equalsIgnoreCase(v)) {
            return SpeedUnit.MPH;
        }
        if (KMH.equalsIgnoreCase(v)) {
            return SpeedUnit.KMH;
        }
        this.logger.warn("Unknown speed unit \"{}\"", (Object)v);
        return null;
    }

    public String marshal(SpeedUnit v) throws Exception {
        switch (v) {
            case KMH: {
                return KMH;
            }
            case MPH: {
                return MPH;
            }
        }
        return "";
    }
}

