/*
 * Decompiled with CFR 0.152.
 */
package com.github.fedy2.weather.binding.adapter;

import com.github.fedy2.weather.data.unit.DistanceUnit;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistanceUnitAdapter
extends XmlAdapter<String, DistanceUnit> {
    private static final String MI = "mi";
    private static final String KM = "km";
    private Logger logger = LoggerFactory.getLogger(DistanceUnitAdapter.class);

    public DistanceUnit unmarshal(String v) throws Exception {
        if (MI.equalsIgnoreCase(v)) {
            return DistanceUnit.MI;
        }
        if (KM.equalsIgnoreCase(v)) {
            return DistanceUnit.KM;
        }
        this.logger.warn("Unknown distance unit \"{}\"", (Object)v);
        return null;
    }

    public String marshal(DistanceUnit v) throws Exception {
        switch (v) {
            case KM: {
                return KM;
            }
            case MI: {
                return MI;
            }
        }
        return "";
    }
}

