/*
 * Decompiled with CFR 0.152.
 */
package com.github.fedy2.weather;

import com.github.fedy2.weather.QueryBuilder;
import com.github.fedy2.weather.binding.RSSParser;
import com.github.fedy2.weather.data.Channel;
import com.github.fedy2.weather.data.Rss;
import com.github.fedy2.weather.data.unit.DegreeUnit;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YahooWeatherService {
    private static final String WEATHER_SERVICE_BASE_URL = "https://query.yahooapis.com/v1/public/yql";
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private Logger logger = LoggerFactory.getLogger(YahooWeatherService.class);
    private RSSParser parser = new RSSParser();
    private Proxy proxy;

    public YahooWeatherService() throws JAXBException {
        this.proxy = Proxy.NO_PROXY;
    }

    public YahooWeatherService(Proxy proxy) throws JAXBException {
        this.proxy = proxy;
    }

    public Channel getForecast(String woeid, DegreeUnit unit) throws JAXBException, IOException {
        QueryBuilder query = new QueryBuilder();
        query.woeid(woeid).unit(unit);
        List<Channel> channels = this.execute(query.build());
        if (channels.isEmpty()) {
            throw new IllegalStateException("No results from the service.");
        }
        return channels.get(0);
    }

    public LimitDeclaration getForecastForLocation(String location, DegreeUnit unit) {
        final QueryBuilder query = new QueryBuilder();
        query.location(location).unit(unit);
        return new LimitDeclaration(){

            @Override
            public List<Channel> last(int count) throws JAXBException, IOException {
                query.last(count);
                return YahooWeatherService.this.execute(query.build());
            }

            @Override
            public List<Channel> first(int count) throws JAXBException, IOException {
                query.first(count);
                return YahooWeatherService.this.execute(query.build());
            }

            @Override
            public List<Channel> all() throws JAXBException, IOException {
                return YahooWeatherService.this.execute(query.build());
            }
        };
    }

    private String composeUrl(String query) {
        this.logger.trace("query: {}", (Object)query);
        StringBuilder url = new StringBuilder(WEATHER_SERVICE_BASE_URL);
        try {
            url.append("?q=").append(URLEncoder.encode(query, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Url encoding failed", e);
        }
        return url.toString();
    }

    private List<Channel> execute(String query) throws IOException, JAXBException {
        String url = this.composeUrl(query);
        String xml = this.retrieveRSS(url);
        Rss rss = this.parser.parse(xml);
        return rss.getChannels();
    }

    private String retrieveRSS(String serviceUrl) throws IOException {
        URL url = new URL(serviceUrl);
        URLConnection connection = url.openConnection(this.proxy);
        InputStream is = connection.getInputStream();
        InputStreamReader reader = new InputStreamReader(is);
        StringWriter writer = new StringWriter();
        YahooWeatherService.copy(reader, writer);
        reader.close();
        is.close();
        return writer.toString();
    }

    private static long copy(Reader input, Writer output) throws IOException {
        char[] buffer = new char[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static interface LimitDeclaration {
        public List<Channel> first(int var1) throws JAXBException, IOException;

        public List<Channel> last(int var1) throws JAXBException, IOException;

        public List<Channel> all() throws JAXBException, IOException;
    }
}

