package at.creadoo.homer.shell.presence.commands.util;

import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.Terminal;
import org.apache.log4j.Logger;

public class ConsoleUtil {

    private static final Logger log = Logger.getLogger(ConsoleUtil.class);
    
	public ConsoleUtil() {
		//
	}
    
	/**
	 * Retrieves the current size of the console
	 */
    public static Size getConsoleSize(final Session session) {
		// Retrieve the terminal of the current session from Karaf
		final Terminal terminal = session.getTerminal();
		if (terminal != null) {
			return new Size(terminal.getWidth(), terminal.getHeight());
		}
		
		log.error("Retrieved object is not a terminal. Returning default values.");
		return new Size(50, 50);
	}
    
    public static class Size {

		private Integer width, height;

		public Size() {
			this(0, 0);
		}

		public Size(final int width, final int height) {
			this.width = width;
			this.height = height;
		}

		public Size(final Integer width, final Integer height) {
			this.width = width;
			this.height = height;
		}

		public Size(final Size size) {
			this.width = size.width;
			this.height = size.height;
		}

		public Integer getWidth() {
			return width;
		}

		public Integer getHeight() {
			return height;
		}

		@Override
		public boolean equals(final Object o) {
			if (this == o)
				return true;
			if (!(o instanceof Size))
				return false;
			Size sz = (Size) o;
			return width == sz.width && height == sz.height;
		}

		@Override
		public String toString() {
			return "Size(" + width + ", " + height + ")";
		}

		@Override
		public Size clone() {
			return new Size(this);
		}

	}

}
