package at.creadoo.homer.shell.presence.commands;

import java.util.Map;

import org.apache.felix.gogo.commands.Command;

/**
 * Command to list all variables.
 */
@Command(scope = "presence", name = "variables", description = "Show the variables used for presence simulator.")
public class PresenceVariables extends AbstractCommand {

    protected static final String LIST_HEADER_FORMAT = "%-15s %-15s";
    protected static final String LIST_OUTPUT_FORMAT = "%-15s %-15s";

    protected static final String UNKNOWN = "---";
    protected static final String ITEM_NAME = "Name";
    protected static final String ITEM_VALUE = "Value";
    
    @Override
	protected Object doExecute() throws Exception {
    	if (getPresenceSimulator() != null) {
			final Map<String, String> items = getPresenceSimulator().getVariables();
			getConsole().println(String.format(LIST_HEADER_FORMAT, ITEM_NAME, ITEM_VALUE));

			for (String key : items.keySet()) {
				getConsole().println(String.format(LIST_OUTPUT_FORMAT, key, items.get(key) == null ? UNKNOWN : items.get(key)));
			}
    	}
        
        return null;
    }

}
