package at.creadoo.homer.shell.presence.commands.util;

import jline.Terminal;
import org.apache.felix.service.command.CommandSession;
import org.apache.log4j.Logger;

public class ConsoleUtil {

    private static final Logger log = Logger.getLogger(ConsoleUtil.class);
    
	public ConsoleUtil() {
		//
	}

	/**
	 * Retrieves the current size of the console using jline.
	 */
	public static Size getConsoleSize(final CommandSession session) {
		// Retrieve the terminal of the current session from Karaf
		final Object obj = session.get(".jline.terminal");
		if (obj == null) {
			log.error("Couldn't retrieve terminal");
		}
		
		if (obj instanceof Terminal) {
			Terminal terminal = (Terminal) obj;
			return new Size(terminal.getWidth(), terminal.getHeight());
		} else {
			log.error("Object is not terminal: " + obj.getClass().getName());
		}
		
		return null;
	}

	public static class Size {

		private Integer width, height;

		public Size() {
			this(0, 0);
		}

		public Size(final int width, final int height) {
			this.width = width;
			this.height = height;
		}

		public Size(final Integer width, final Integer height) {
			this.width = width;
			this.height = height;
		}

		public Size(final Size size) {
			this.width = size.width;
			this.height = size.height;
		}

		public Integer getWidth() {
			return width;
		}

		public Integer getHeight() {
			return height;
		}

		@Override
		public boolean equals(final Object o) {
			if (this == o)
				return true;
			if (!(o instanceof Size))
				return false;
			Size sz = (Size) o;
			return width == sz.width && height == sz.height;
		}

		@Override
		public String toString() {
			return "Size(" + width + ", " + height + ")";
		}

		@Override
		public Size clone() {
			return new Size(this);
		}

	}

}
