/*
 * Decompiled with CFR 0.152.
 */
package at.creadoo.homer.shell.presence.commands;

import at.creadoo.homer.processing.presence.model.ActuatorItem;
import at.creadoo.homer.shell.presence.commands.AbstractCommand;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.felix.gogo.commands.Command;
import org.joda.time.ReadablePartial;

@Command(scope="presence", name="list", description="List scheduled items.")
public class PresenceList
extends AbstractCommand {
    protected static final String HEADER_FORMAT = "%-8s %-30s %-20s %-20s";
    protected static final String OUTPUT_FORMAT = "%-8s %-30s %-20s %-20s";
    protected static final String UNKNOWN = "---";
    protected static final String ITEM_DEVICE = "Device";
    protected static final String ITEM_MESSAGE = "Message";
    protected static final String ITEM_START_TIME = "Start Time";
    protected static final String ITEM_END_TIME = "End Time";

    protected Object doExecute() throws Exception {
        if (this.getPresenceSimulator() != null) {
            this.getConsole().println(String.format("%-8s %-30s %-20s %-20s", ITEM_DEVICE, ITEM_MESSAGE, ITEM_START_TIME, ITEM_END_TIME));
            List actuatorItems = this.getPresenceSimulator().getActuatorItems();
            Collections.sort(actuatorItems, new SortActuatorItemByDeviceId());
            for (ActuatorItem item : actuatorItems) {
                this.getConsole().println(String.format("%-8s %-30s %-20s %-20s", item.getDevice().getActuatorId(), item.getDeviceMessageType() == null ? UNKNOWN : item.getDeviceMessageType().getTitle(), item.getStartTime() == null ? UNKNOWN : this.TIME_FORMAT.print((ReadablePartial)item.getStartTime()), item.getEndTime() == null ? UNKNOWN : this.TIME_FORMAT.print((ReadablePartial)item.getEndTime())));
            }
        } else {
            this.printError("Presence simulator not available");
        }
        return null;
    }

    private class SortActuatorItemByDeviceId
    implements Comparator<ActuatorItem> {
        private SortActuatorItemByDeviceId() {
        }

        @Override
        public int compare(ActuatorItem item1, ActuatorItem item2) {
            int result = item1.getDevice().getActuatorId().compareTo(item2.getDevice().getActuatorId());
            if (result == 0 && (result = item1.getDeviceMessageType().compareTo((Enum)item2.getDeviceMessageType())) == 0 && (result = item1.getStartTime().compareTo((ReadablePartial)item2.getStartTime())) == 0) {
                result = item1.getEndTime().compareTo((ReadablePartial)item2.getEndTime());
            }
            return result;
        }
    }
}

