/*
 * Decompiled with CFR 0.152.
 */
package at.creadoo.homer.shell.presence.commands;

import at.creadoo.homer.processing.presence.PresenceSimulator;
import java.io.PrintStream;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;

public abstract class AbstractCommand
extends OsgiCommandSupport {
    private static final String ERROR_PREFIX = "[ERROR] ";
    protected static final String ERROR_UNKNOWN = "Error while executing command";
    protected static final String ERROR_PRESENCE_SIMULATOR = "Presence simulator not available";
    protected static final String ERROR_PARSE = "Unable to parse given argument";
    public final DateTimeFormatter TIME_FORMAT = DateTimeFormat.forPattern((String)"HH:mm");
    public final DateTimeFormatter TIME_PARSER = new DateTimeFormatterBuilder().append(null, new DateTimeParser[]{this.TIME_FORMAT.getParser()}).toFormatter();
    private PresenceSimulator presenceSimulator;

    protected AbstractCommand() {
    }

    public final void setPresenceSimulator(PresenceSimulator presenceSimulator) {
        this.presenceSimulator = presenceSimulator;
    }

    protected final PresenceSimulator getPresenceSimulator() {
        return this.presenceSimulator;
    }

    protected final CommandSession getSession() {
        return this.session;
    }

    protected final PrintStream getConsole() {
        return this.session.getConsole();
    }

    protected final void printStatus() {
        if (this.getPresenceSimulator() != null) {
            if (this.getPresenceSimulator().isEnabled()) {
                this.getConsole().println("Presence simulator is enabled");
            } else {
                this.getConsole().println("Presence simulator is disabled");
            }
        } else {
            this.printError(ERROR_PRESENCE_SIMULATOR);
        }
    }

    protected final void printError(String error) {
        this.getConsole().println(ERROR_PREFIX + error);
        this.log.error(error);
    }

    protected final void printError(String error, Throwable ex) {
        this.getConsole().println(ERROR_PREFIX + error);
        ex.printStackTrace(this.getConsole());
        this.log.error(error, ex);
    }
}

