package at.creadoo.homer.shell.presence.commands;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.apache.felix.gogo.commands.Command;

import at.creadoo.homer.processing.presence.model.ActuatorItem;

/**
 * Command to list all scheduled items.
 */
@Command(scope = "presence", name = "list", description = "List scheduled items.")
public class PresenceList extends AbstractCommand {

    protected static final String HEADER_FORMAT = "%-8s %-30s %-20s %-20s";
    protected static final String OUTPUT_FORMAT = "%-8s %-30s %-20s %-20s";
    
    protected static final String UNKNOWN = "---";
    protected static final String ITEM_DEVICE = "Device";
    protected static final String ITEM_MESSAGE = "Message";
    protected static final String ITEM_START_TIME = "Start Time";
    protected static final String ITEM_END_TIME = "End Time";
    
    @Override
	protected Object doExecute() throws Exception {
		if (getPresenceSimulator() != null) {
			getConsole().println(String.format(HEADER_FORMAT, ITEM_DEVICE, ITEM_MESSAGE, ITEM_START_TIME, ITEM_END_TIME));

			final List<ActuatorItem> actuatorItems = getPresenceSimulator().getActuatorItems();
			
			Collections.sort(actuatorItems, new SortActuatorItemByDeviceId());
			
			for (ActuatorItem item : actuatorItems) {
				getConsole().println(String.format(OUTPUT_FORMAT, item.getDevice().getActuatorId(), item.getDeviceMessageType() == null ? UNKNOWN : item.getDeviceMessageType().getTitle(), item.getStartTime() == null ? UNKNOWN : TIME_FORMAT.print(item.getStartTime()), item.getEndTime() == null ? UNKNOWN : TIME_FORMAT.print(item.getEndTime())));
			}
		} else {
			printError(ERROR_PRESENCE_SIMULATOR);
		}
        
        return null;
    }
    
	private class SortActuatorItemByDeviceId implements Comparator<ActuatorItem> {
		@Override
		public int compare(final ActuatorItem item1, final ActuatorItem item2) {
			int result = item1.getDevice().getActuatorId().compareTo(item2.getDevice().getActuatorId());
			if (result == 0) {
				result = item1.getDeviceMessageType().compareTo(item2.getDeviceMessageType());
				if (result == 0) {
					result = item1.getStartTime().compareTo(item2.getStartTime());
					if (result == 0) {
						result = item1.getEndTime().compareTo(item2.getEndTime());
					}
				}
			}
			return result;
		}
	}

}
