package at.creadoo.homer.shell.presence.commands;

import java.io.PrintStream;

import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;

import at.creadoo.homer.processing.presence.PresenceSimulator;

public abstract class AbstractCommand extends OsgiCommandSupport {

	private static final String ERROR_PREFIX = "[ERROR] ";
	
    protected static final String ERROR_UNKNOWN = "Error while executing command";
    
    protected static final String ERROR_PRESENCE_SIMULATOR = "Presence simulator not available";
    protected static final String ERROR_PARSE = "Unable to parse given argument";

	public final DateTimeFormatter TIME_FORMAT = DateTimeFormat.forPattern("HH:mm");
	
	public final DateTimeFormatter TIME_PARSER;

    private PresenceSimulator presenceSimulator;
	
    protected AbstractCommand() {
		TIME_PARSER = new DateTimeFormatterBuilder().append(null, // because no printing is required
			new DateTimeParser[] {
				TIME_FORMAT.getParser()
			}
		).toFormatter();
	}
    
    public final void setPresenceSimulator(final PresenceSimulator presenceSimulator) {
    	this.presenceSimulator = presenceSimulator;
    }
    
    protected final PresenceSimulator getPresenceSimulator() {
    	return this.presenceSimulator;
    }

    protected final CommandSession getSession() {
		return this.session;
    }

    protected final PrintStream getConsole() {
		return this.session.getConsole();
    }

    protected final void printStatus() {
		if (getPresenceSimulator() != null) {
		    if (getPresenceSimulator().isEnabled()) {
				getConsole().println("Presence simulator is enabled");
			} else {
				getConsole().println("Presence simulator is disabled");
			}
		} else {
			printError(ERROR_PRESENCE_SIMULATOR);
		}
    }
    
    protected final void printError(String error) {
    	getConsole().println(ERROR_PREFIX + error);
    	log.error(error);
    }
    
    protected final void printError(String error, Throwable ex) {
    	getConsole().println(ERROR_PREFIX + error);
		ex.printStackTrace(getConsole());
    	log.error(error, ex);
    }

}
