/*
 * Decompiled with CFR 0.152.
 */
package at.creadoo.homer.shell.data.commands;

import at.creadoo.homer.processing.data.util.Util;
import at.creadoo.homer.shell.data.commands.CommandSupport;
import at.creadoo.homer.shell.data.commands.completers.FlatCompleter;
import at.creadoo.homer.shell.data.commands.completers.TimeUnitCompleter;
import java.util.concurrent.TimeUnit;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.Col;
import org.apache.karaf.shell.support.table.Row;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="data", name="display", description="Show values provided by given services.")
@Service
public class DataDisplay
extends CommandSupport {
    @Argument(index=0, name="flat", description="The flat id which should be used.", required=true, multiValued=false)
    @Completion(value=FlatCompleter.class)
    Integer flatId;
    @Argument(index=1, name="period", description="The desired period.", required=false, multiValued=false)
    Integer period;
    @Argument(index=2, name="unit", description="The desired time unit.", required=false, multiValued=false)
    @Completion(value=TimeUnitCompleter.class)
    String sUnit;

    public Object execute() throws Exception {
        ShellTable table = new ShellTable();
        table.column(new Col("Service").alignLeft());
        TimeUnit unit = this.sUnit == null || this.sUnit.isEmpty() ? null : TimeUnit.valueOf(TimeUnit.class, this.sUnit.trim());
        if (this.period != null && this.period > 0 && unit != null) {
            table.column(new Col("Value [Last " + this.period + " " + unit.name() + "]").alignLeft());
            if (this.getHumidityService() != null) {
                this.printRow(table, "Humidity Service", Util.round((Double)this.getHumidityService().getValue(this.flatId.intValue(), (long)this.period.intValue(), unit)));
            } else {
                this.printError("Humidity Service not available");
            }
            if (this.getIndoorClimateService() != null) {
                this.printRow(table, "Indoor Climate Service", this.getIndoorClimateService().getIndoorClimateType(this.flatId.intValue(), (long)this.period.intValue(), unit).toString());
            } else {
                this.printError("Indoor Climate Service not available");
            }
            if (this.getRainService() != null) {
                Double value = Util.round((Double)this.getRainService().getValue(this.flatId.intValue(), (long)this.period.intValue(), unit));
                this.printRow(table, "Rain Service", value + " [" + this.getRainService().getRainType(value, (long)this.period.intValue(), unit) + "]");
            } else {
                this.printError("Rain Service not available");
            }
            if (this.getTemperatureInsideService() != null) {
                this.printRow(table, "Temperature Inside Service", Util.round((Double)this.getTemperatureInsideService().getValue(this.flatId.intValue())));
            } else {
                this.printError("Temperature Inside Service not available");
            }
            if (this.getTemperatureOutsideService() != null) {
                this.printRow(table, "Temperature Outside Service", Util.round((Double)this.getTemperatureOutsideService().getValue(this.flatId.intValue())));
            } else {
                this.printError("Temperature Outside Service not available");
            }
        } else {
            table.column(new Col("Last Value").alignLeft());
            if (this.getHumidityService() != null) {
                this.printRow(table, "Humidity Service", Util.round((Double)this.getHumidityService().getLastValue(this.flatId.intValue())));
            } else {
                this.printError("Humidity Service not available");
            }
            if (this.getIndoorClimateService() != null) {
                this.printRow(table, "Indoor Climate Service", this.getIndoorClimateService().getIndoorClimateType(this.flatId.intValue()).toString());
            } else {
                this.printError("Indoor Climate Service not available");
            }
            if (this.getRainService() != null) {
                Double value = Util.round((Double)this.getRainService().getLastValue(this.flatId.intValue()));
                this.printRow(table, "Rain Service", value + " [" + this.getRainService().getRainType(value) + "]");
            } else {
                this.printError("Rain Service not available");
            }
            if (this.getTemperatureInsideService() != null) {
                this.printRow(table, "Temperature Inside Service", Util.round((Double)this.getTemperatureInsideService().getLastValue(this.flatId.intValue())));
            } else {
                this.printError("Temperature Inside Service not available");
            }
            if (this.getTemperatureOutsideService() != null) {
                this.printRow(table, "Temperature Outside Service", Util.round((Double)this.getTemperatureOutsideService().getLastValue(this.flatId.intValue())));
            } else {
                this.printError("Temperature Outside Service not available");
            }
        }
        table.print(this.getConsole());
        return null;
    }

    private Row printRow(ShellTable table, String service, Double value) {
        if (value != null) {
            return this.printRow(table, service, Double.toString(value));
        }
        return this.printRow(table, service, "null");
    }

    private Row printRow(ShellTable table, String service, String value) {
        if (table == null || service == null) {
            return null;
        }
        Row row = table.addRow();
        row.addContent(new Object[]{service});
        row.addContent(new Object[]{value});
        return row;
    }
}

