/*
 * Decompiled with CFR 0.152.
 */
package at.creadoo.homer.shell.data.commands;

import at.creadoo.homer.processing.data.HumidityService;
import at.creadoo.homer.processing.data.IndoorClimateService;
import at.creadoo.homer.processing.data.RainService;
import at.creadoo.homer.processing.data.TemperatureInsideService;
import at.creadoo.homer.processing.data.TemperatureOutsideService;
import java.io.PrintStream;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.console.Session;
import org.apache.log4j.Logger;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;

public abstract class CommandSupport
implements Action {
    private static final Logger log = Logger.getLogger(CommandSupport.class);
    protected static final String HUMIDITY_SERVICE_TITLE = "Humidity Service";
    protected static final String INDOOR_CLIMATE_SERVICE_TITLE = "Indoor Climate Service";
    protected static final String RAIN_SERVICE_TITLE = "Rain Service";
    protected static final String TEMPERATURE_INSIDE_SERVICE_TITLE = "Temperature Inside Service";
    protected static final String TEMPERATURE_OUTSIDE_SERVICE_TITLE = "Temperature Outside Service";
    private static final String ERROR_PREFIX = "[ERROR] ";
    protected static final String ERROR_UNKNOWN = "Error while executing command";
    protected static final String ERROR_HUMIDITY_SERVICE = "Humidity Service not available";
    protected static final String ERROR_INDOOR_CLIMATE_SERVICE = "Indoor Climate Service not available";
    protected static final String ERROR_RAIN_SERVICE = "Rain Service not available";
    protected static final String ERROR_TEMPERATURE_INSIDE_SERVICE = "Temperature Inside Service not available";
    protected static final String ERROR_TEMPERATURE_OUTSIDE_SERVICE = "Temperature Outside Service not available";
    protected static final String ERROR_PARSE = "Unable to parse given argument";
    public final DateTimeFormatter TIME_FORMAT = DateTimeFormat.forPattern((String)"HH:mm");
    public final DateTimeFormatter TIME_PARSER = new DateTimeFormatterBuilder().append(null, new DateTimeParser[]{this.TIME_FORMAT.getParser()}).toFormatter();
    @Reference
    private HumidityService humidityService;
    @Reference
    private IndoorClimateService indoorClimateService;
    @Reference
    private RainService rainService;
    @Reference
    private TemperatureInsideService temperatureInsideService;
    @Reference
    private TemperatureOutsideService temperatureOutsideService;
    @Reference
    private Session session;

    protected CommandSupport() {
    }

    public final void setHumidityService(HumidityService humidityService) {
        this.humidityService = humidityService;
    }

    protected final HumidityService getHumidityService() {
        return this.humidityService;
    }

    public final void setIndoorClimateService(IndoorClimateService indoorClimateService) {
        this.indoorClimateService = indoorClimateService;
    }

    protected final IndoorClimateService getIndoorClimateService() {
        return this.indoorClimateService;
    }

    public final void setRainService(RainService rainService) {
        this.rainService = rainService;
    }

    protected final RainService getRainService() {
        return this.rainService;
    }

    public final void setTemperatureInsideService(TemperatureInsideService temperatureInsideService) {
        this.temperatureInsideService = temperatureInsideService;
    }

    protected final TemperatureInsideService getTemperatureInsideService() {
        return this.temperatureInsideService;
    }

    public final void setTemperatureOutsideService(TemperatureOutsideService temperatureOutsideService) {
        this.temperatureOutsideService = temperatureOutsideService;
    }

    protected final TemperatureOutsideService getTemperatureOutsideService() {
        return this.temperatureOutsideService;
    }

    public final void setSession(Session session) {
        this.session = session;
    }

    protected final Session getSession() {
        return this.session;
    }

    protected final PrintStream getConsole() {
        return this.session.getConsole();
    }

    protected final void printStatus() {
        if (this.getHumidityService() != null) {
            this.getConsole().println("Humidity Service available");
        } else {
            this.printError(ERROR_HUMIDITY_SERVICE);
        }
        if (this.getIndoorClimateService() != null) {
            this.getConsole().println("Indoor Climate Service available");
        } else {
            this.printError(ERROR_INDOOR_CLIMATE_SERVICE);
        }
        if (this.getRainService() != null) {
            this.getConsole().println("Rain Service available");
        } else {
            this.printError(ERROR_RAIN_SERVICE);
        }
        if (this.getTemperatureInsideService() != null) {
            this.getConsole().println("Temperature Inside Service available");
        } else {
            this.printError(ERROR_TEMPERATURE_INSIDE_SERVICE);
        }
        if (this.getTemperatureOutsideService() != null) {
            this.getConsole().println("Temperature Outside Service available");
        } else {
            this.printError(ERROR_TEMPERATURE_OUTSIDE_SERVICE);
        }
    }

    protected final void printError(String error) {
        this.getConsole().println(ERROR_PREFIX + error);
        log.error((Object)error);
    }

    protected final void printError(String error, Throwable ex) {
        this.getConsole().println(ERROR_PREFIX + error);
        ex.printStackTrace(this.getConsole());
        log.error((Object)error, ex);
    }
}

