package at.creadoo.homer.shell.data.commands.completers;

import java.util.List;
import java.util.concurrent.TimeUnit;

import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.completers.StringsCompleter;

/**
 * A completer for the {@link TimeUnit} context.
 */
@Service
public class TimeUnitCompleter implements Completer {
	
    @Override
    public int complete(final Session session, final CommandLine commandLine, final List<String> candidates) {
    	final StringsCompleter delegate = new StringsCompleter();
        try {
        	for (final TimeUnit unit : TimeUnit.values()) {
        		delegate.getStrings().add(unit.name());
        	}
        } catch (Exception e) {
            // nothing to do
        }
    	return delegate.complete(session, commandLine, candidates);
    }

}
