package at.creadoo.homer.shell.data.commands.completers;

import java.util.List;

import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.completers.StringsCompleter;

import at.ac.ait.hbs.homer.core.common.DataAccess;
import at.ac.ait.hbs.homer.core.common.model.DBFlat;

/**
 * A completer for the flat context.
 */
@Service
public class FlatCompleter implements Completer {

    @Reference
    private DataAccess dataAccess;
	
    @Override
    public int complete(final Session session, final CommandLine commandLine, final List<String> candidates) {
    	StringsCompleter delegate = new StringsCompleter();
        try {
            if (dataAccess != null) {
	            final List<DBFlat> flats = dataAccess.getFlats();
	        	for (final DBFlat flat : flats) {
	        		delegate.getStrings().add(flat.getId().toString());
	        	}
            }
        } catch (Exception e) {
            // nothing to do
        }
    	return delegate.complete(session, commandLine, candidates);
    }
    
    public final void setDataAccess(final DataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

}
