package at.creadoo.homer.shell.data.commands;

import java.io.PrintStream;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.console.Session;
import org.apache.log4j.Logger;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;

import at.creadoo.homer.processing.data.HumidityService;
import at.creadoo.homer.processing.data.IndoorClimateService;
import at.creadoo.homer.processing.data.RainService;
import at.creadoo.homer.processing.data.TemperatureInsideService;
import at.creadoo.homer.processing.data.TemperatureOutsideService;

public abstract class CommandSupport implements Action {
	
	private static final Logger log = Logger.getLogger(CommandSupport.class);

    protected static final String HUMIDITY_SERVICE_TITLE = "Humidity Service";

    protected static final String INDOOR_CLIMATE_SERVICE_TITLE = "Indoor Climate Service";

    protected static final String RAIN_SERVICE_TITLE = "Rain Service";

    protected static final String TEMPERATURE_INSIDE_SERVICE_TITLE = "Temperature Inside Service";

    protected static final String TEMPERATURE_OUTSIDE_SERVICE_TITLE = "Temperature Outside Service";
	
	private static final String ERROR_PREFIX = "[ERROR] ";
	
    protected static final String ERROR_UNKNOWN = "Error while executing command";
    
    protected static final String ERROR_HUMIDITY_SERVICE = HUMIDITY_SERVICE_TITLE + " not available";
    
    protected static final String ERROR_INDOOR_CLIMATE_SERVICE = INDOOR_CLIMATE_SERVICE_TITLE + " not available";
    
    protected static final String ERROR_RAIN_SERVICE = RAIN_SERVICE_TITLE + " not available";
    
    protected static final String ERROR_TEMPERATURE_INSIDE_SERVICE = TEMPERATURE_INSIDE_SERVICE_TITLE + " not available";
    
    protected static final String ERROR_TEMPERATURE_OUTSIDE_SERVICE = TEMPERATURE_OUTSIDE_SERVICE_TITLE + " not available";
    
    protected static final String ERROR_PARSE = "Unable to parse given argument";

	public final DateTimeFormatter TIME_FORMAT = DateTimeFormat.forPattern("HH:mm");
	
	public final DateTimeFormatter TIME_PARSER;

	@Reference
	private HumidityService humidityService;

	@Reference
	private IndoorClimateService indoorClimateService;

	@Reference
	private RainService rainService;

	@Reference
	private TemperatureInsideService temperatureInsideService;

	@Reference
	private TemperatureOutsideService temperatureOutsideService;

	@Reference
	private Session session;
	
    protected CommandSupport() {
		TIME_PARSER = new DateTimeFormatterBuilder().append(null, // because no printing is required
			new DateTimeParser[] {
				TIME_FORMAT.getParser()
			}
		).toFormatter();
	}
    
    public final void setHumidityService(final HumidityService humidityService) {
    	this.humidityService = humidityService;
    }
    
    protected final HumidityService getHumidityService() {
    	return this.humidityService;
    }
    
    public final void setIndoorClimateService(final IndoorClimateService indoorClimateService) {
    	this.indoorClimateService = indoorClimateService;
    }
    
    protected final IndoorClimateService getIndoorClimateService() {
    	return this.indoorClimateService;
    }
    
    public final void setRainService(final RainService rainService) {
    	this.rainService = rainService;
    }
    
    protected final RainService getRainService() {
    	return this.rainService;
    }
    
    public final void setTemperatureInsideService(final TemperatureInsideService temperatureInsideService) {
    	this.temperatureInsideService = temperatureInsideService;
    }
    
    protected final TemperatureInsideService getTemperatureInsideService() {
    	return this.temperatureInsideService;
    }
    
    public final void setTemperatureOutsideService(final TemperatureOutsideService temperatureOutsideService) {
    	this.temperatureOutsideService = temperatureOutsideService;
    }
    
    protected final TemperatureOutsideService getTemperatureOutsideService() {
    	return this.temperatureOutsideService;
    }
    
    public final void setSession(final Session session) {
    	this.session = session;
    }

    protected final Session getSession() {
		return this.session;
    }

    protected final PrintStream getConsole() {
		return this.session.getConsole();
    }

    protected final void printStatus() {
		if (getHumidityService() != null) {
			getConsole().println(HUMIDITY_SERVICE_TITLE + " available");
		} else {
			printError(ERROR_HUMIDITY_SERVICE);
		}
		if (getIndoorClimateService() != null) {
			getConsole().println(INDOOR_CLIMATE_SERVICE_TITLE + " available");
		} else {
			printError(ERROR_INDOOR_CLIMATE_SERVICE);
		}
		if (getRainService() != null) {
			getConsole().println(RAIN_SERVICE_TITLE + " available");
		} else {
			printError(ERROR_RAIN_SERVICE);
		}
		if (getTemperatureInsideService() != null) {
			getConsole().println(TEMPERATURE_INSIDE_SERVICE_TITLE + " available");
		} else {
			printError(ERROR_TEMPERATURE_INSIDE_SERVICE);
		}
		if (getTemperatureOutsideService() != null) {
			getConsole().println(TEMPERATURE_OUTSIDE_SERVICE_TITLE + " available");
		} else {
			printError(ERROR_TEMPERATURE_OUTSIDE_SERVICE);
		}
    }
    
    protected final void printError(String error) {
    	getConsole().println(ERROR_PREFIX + error);
    	log.error(error);
    }
    
    protected final void printError(String error, Throwable ex) {
    	getConsole().println(ERROR_PREFIX + error);
		ex.printStackTrace(getConsole());
    	log.error(error, ex);
    }

}
