/*
 * Decompiled with CFR 0.152.
 */
package at.creadoo.homer.processing.presence.util;

import com.github.fedy2.weather.YahooWeatherService;
import com.github.fedy2.weather.data.Channel;
import com.github.fedy2.weather.data.unit.DegreeUnit;
import com.github.fedy2.weather.data.unit.Time;
import com.github.fedy2.weather.data.unit.TimeConvention;
import java.io.IOException;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.joda.time.LocalTime;

public class WeatherUtil {
    private static final Logger log = Logger.getLogger(WeatherUtil.class);

    public static final LocalTime convertTime(Time time) {
        LocalTime result = null;
        if (time != null) {
            result = new LocalTime().withHourOfDay(time.getHours()).withMinuteOfHour(time.getMinutes()).withSecondOfMinute(0).withMillisOfSecond(0);
            if (time.getConvention().equals((Object)TimeConvention.PM)) {
                result = result.plusHours(12);
            }
        }
        return result;
    }

    public static final Channel getWeatherForecast(String woeid, DegreeUnit unit) {
        try {
            YahooWeatherService service = new YahooWeatherService();
            Channel channel = service.getForecast(woeid, unit);
            return channel;
        }
        catch (JAXBException ex) {
            log.error((Object)"Error parsing weather data", (Throwable)ex);
        }
        catch (IOException ex) {
            log.error((Object)"Error parsing weather data", (Throwable)ex);
        }
        return null;
    }
}

