/*
 * Decompiled with CFR 0.152.
 */
package at.creadoo.homer.processing.presence.util;

import at.ac.ait.hbs.homer.core.common.util.PropertyUtil;
import at.creadoo.homer.processing.presence.Constants;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.joda.time.LocalTime;

public class Util {
    private static final Logger log = Logger.getLogger(Util.class);

    public static Map<String, String> toMap(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> map = new HashMap<String, String>(dictionary.size());
        Enumeration<String> keys = dictionary.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            map.put(key, dictionary.get(key).toString());
        }
        return map;
    }

    public static Map<String, String> matchingSubset(Map<String, String> properties, String prefix, boolean keepPrefix) {
        String prefixMatch;
        String prefixSelf;
        HashMap<String, String> result = new HashMap<String, String>();
        if (prefix == null || prefix.length() == 0) {
            return result;
        }
        if (prefix.charAt(prefix.length() - 1) != '.') {
            prefixSelf = prefix;
            prefixMatch = prefix + '.';
        } else {
            prefixSelf = prefix.substring(0, prefix.length() - 1);
            prefixMatch = prefix;
        }
        for (String key : properties.keySet()) {
            if (keepPrefix) {
                if (!key.startsWith(prefixMatch) && !key.equals(prefixSelf)) continue;
                result.put(key, properties.get(key));
                continue;
            }
            if (!key.startsWith(prefixMatch)) continue;
            result.put(key.substring(prefixMatch.length()), properties.get(key));
        }
        return result;
    }

    public static String getProperty(Map<String, String> properties, String key) {
        log.debug((Object)("Get value for '" + key + "' from: " + properties));
        if (properties != null && properties.keySet().contains(key)) {
            return PropertyUtil.sanitizeValue((String)properties.get(key));
        }
        return "";
    }

    public static void replaceProperty(Map<String, String> properties, String target, String replacement) {
        for (String key : properties.keySet()) {
            String item = properties.get(key);
            if (!item.contains(target)) continue;
            properties.put(key, item.replace(target, replacement));
        }
    }

    public static LocalTime getStartTime(String time) {
        if (time == null || time.isEmpty()) {
            return null;
        }
        String tempTime = time.contains("+") ? time.substring(0, time.indexOf("+")) : (time.contains("-") ? time.substring(0, time.indexOf("-")) : time);
        try {
            return Constants.parseTime(tempTime);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static LocalTime getEndTime(String time) {
        LocalTime startTime = Util.getStartTime(time);
        if (time == null || time.isEmpty()) {
            return null;
        }
        if (time.contains("+") && startTime != null) {
            return startTime.plusMinutes(Integer.parseInt(time.substring(time.indexOf("+") + 1)));
        }
        if (time.contains("-")) {
            try {
                return Constants.parseTime(time.substring(time.indexOf("-") + 1));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }
}

