package at.creadoo.homer.processing.presence.model;

import java.io.Serializable;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.joda.time.LocalTime;

import at.ac.ait.hbs.homer.core.common.enumerations.DeviceMessageType;
import at.ac.ait.hbs.homer.core.common.model.DBActuator;

/**
 * Model class holding information sent in the sub profile
 * 
 * @author roedll
 *
 */
public class ActuatorItem implements Serializable, Cloneable {

	private static final long serialVersionUID = 1L;
	
	private DBActuator device = null;
	
	private DeviceMessageType deviceMessageType = null;
	
	private LocalTime startTime = null;
	
	private LocalTime endTime = null;
    
    public ActuatorItem() {
    	//
    }
    
    public ActuatorItem(final DBActuator device, final DeviceMessageType deviceMessageType, final LocalTime startTime) {
    	setDevice(device);
    	setDeviceMessageType(deviceMessageType);
    	setStartTime(startTime);
    }
    
    public ActuatorItem(final DBActuator device, final DeviceMessageType deviceMessageType, final LocalTime startTime, final LocalTime endTime) {
    	this(device, deviceMessageType, startTime);
    	setEndTime(endTime);
    }

	public DBActuator getDevice() {
		return device;
	}

	public void setDevice(final DBActuator device) {
		this.device = device;
	}

	public DeviceMessageType getDeviceMessageType() {
		return deviceMessageType;
	}

	public void setDeviceMessageType(final DeviceMessageType deviceMessageType) {
		this.deviceMessageType = deviceMessageType;
	}

    public LocalTime getStartTime() {
		return startTime;
	}

	public void setStartTime(final LocalTime startTime) {
		this.startTime = startTime;
	}

	public LocalTime getEndTime() {
		return endTime;
	}

	public void setEndTime(final LocalTime endTime) {
		this.endTime = endTime;
	}

	@Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(final Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @Override
    public String toString() {
    	return ToStringBuilder.reflectionToString(this);
    }

}
