/*
 * Decompiled with CFR 0.152.
 */
package at.creadoo.homer.processing.presence.impl;

import at.ac.ait.hbs.homer.core.common.DataAccess;
import at.ac.ait.hbs.homer.core.common.configuration.ConfigurationService;
import at.ac.ait.hbs.homer.core.common.configuration.ConfigurationValue;
import at.ac.ait.hbs.homer.core.common.configuration.ConfigurationValueChangeListener;
import at.ac.ait.hbs.homer.core.common.configuration.ConfigurationValueKey;
import at.ac.ait.hbs.homer.core.common.configuration.ConfigurationValueListener;
import at.ac.ait.hbs.homer.core.common.enumerations.DeviceMessageType;
import at.ac.ait.hbs.homer.core.common.enumerations.DeviceType;
import at.ac.ait.hbs.homer.core.common.event.EventBuilder;
import at.ac.ait.hbs.homer.core.common.event.EventProperties;
import at.ac.ait.hbs.homer.core.common.event.EventTopic;
import at.ac.ait.hbs.homer.core.common.event.util.EventUtil;
import at.ac.ait.hbs.homer.core.common.exception.ConfigurationValueTypeMismatchException;
import at.ac.ait.hbs.homer.core.common.model.DBActuator;
import at.ac.ait.hbs.homer.core.common.model.DBMessage;
import at.ac.ait.hbs.homer.core.common.model.DBSensor;
import at.ac.ait.hbs.homer.core.scheduler.Scheduler;
import at.creadoo.homer.processing.presence.Constants;
import at.creadoo.homer.processing.presence.PresenceSimulator;
import at.creadoo.homer.processing.presence.model.ActuatorItem;
import at.creadoo.homer.processing.presence.model.SensorItem;
import at.creadoo.homer.processing.presence.util.RandomUtil;
import at.creadoo.homer.processing.presence.util.Util;
import at.creadoo.homer.processing.presence.util.WeatherUtil;
import com.github.fedy2.weather.data.unit.DegreeUnit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

public class PresenceSimulatorImpl
implements PresenceSimulator,
ManagedService,
EventHandler,
ConfigurationValueChangeListener {
    private static final Logger log = Logger.getLogger(PresenceSimulatorImpl.class);
    private static final String KEY_PREFIX_ACTUATOR = "actuator.";
    private static final String KEY_PREFIX_SENSOR = "sensor.";
    private static final String SCHEDULER_NAME_RECALCULATE = "recalculation-trigger";
    private ServiceRegistration<?> serviceRegistration;
    private final Map<Integer, DBActuator> actuators = new HashMap<Integer, DBActuator>();
    private final Set<ActuatorItem> actuatorItems = Collections.synchronizedSet(new HashSet());
    private final Map<Integer, DBSensor> sensors = new HashMap<Integer, DBSensor>();
    private final Set<SensorItem> sensorItems = Collections.synchronizedSet(new HashSet());
    private Map<String, ActuatorItem> scheduledJobs = new HashMap<String, ActuatorItem>();
    private ConfigurationAdmin configurationAdmin;
    private ConfigurationService configurationService;
    private DataAccess dataAccess;
    private EventAdmin eventAdmin;
    private Scheduler scheduler;
    private Integer flatId;
    private boolean isEnabled = false;

    private void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        this.configurationService.setMetaValue(new ConfigurationValue("at.creadoo.homer.processing.presence.enabled", Boolean.valueOf(this.isEnabled), Boolean.valueOf(false)));
    }

    private Dictionary<String, ?> getConfiguration() {
        try {
            return this.configurationAdmin.getConfiguration("at.creadoo.homer.processing.presence", "?").getProperties();
        }
        catch (IOException ex) {
            log.error((Object)"Error loading configuration", (Throwable)ex);
            return null;
        }
    }

    public void init() {
        String initialEnabled;
        log.info((Object)("Initialize " + this.getClass().getSimpleName() + "..."));
        if (this.configurationService.hasMetaValue(ConfigurationValueKey.FLAT_ID).booleanValue()) {
            try {
                this.flatId = this.configurationService.getMetaValue(ConfigurationValueKey.FLAT_ID).getIntegerValue();
                this.updateDevices(this.flatId);
            }
            catch (ConfigurationValueTypeMismatchException ex) {
                // empty catch block
            }
        }
        this.configurationService.addListener((ConfigurationValueListener)this);
        boolean enabled = false;
        Map<String, String> props = Util.toMap(this.getConfiguration());
        if (props != null && props.containsKey("initial.enabled") && ((initialEnabled = Util.getProperty(props, "initial.enabled")).trim().equalsIgnoreCase("1") || initialEnabled.trim().equalsIgnoreCase("true"))) {
            enabled = true;
        }
        if (enabled) {
            log.info((Object)"Initially enabled");
        } else {
            log.info((Object)"Initially disabled");
        }
        this.setEnabled(enabled);
        this.registerService();
    }

    public void destroy() {
        log.info((Object)("Destroy " + this.getClass().getSimpleName() + "..."));
        this.configurationService.removeListener((ConfigurationValueListener)this);
        this.unregister();
        this.unregisterService();
    }

    public final void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public final void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public final void setDataAccess(DataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    public void setEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public final void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public void enable() {
        this.doEnable();
    }

    @Override
    public void disable() {
        this.doDisable();
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActuatorItem> getActuatorItems() {
        Set<ActuatorItem> set = this.actuatorItems;
        synchronized (set) {
            return new ArrayList<ActuatorItem>(this.actuatorItems);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SensorItem> getSensorItems() {
        Set<SensorItem> set = this.sensorItems;
        synchronized (set) {
            return new ArrayList<SensorItem>(this.sensorItems);
        }
    }

    @Override
    public void recalculate() {
        try {
            this.updated(this.getConfiguration());
        }
        catch (ConfigurationException ex) {
            log.error((Object)"Error while initializing recalculation", (Throwable)ex);
        }
    }

    public void handleEvent(Event event) {
        log.debug((Object)("Received " + event));
        try {
            if (EventUtil.isEventOfType((Event)event, (EventTopic)EventTopic.HOMECONTROL_SENSOR_MESSAGE).booleanValue()) {
                DBMessage message = (DBMessage)event.getProperty(EventProperties.MESSAGE.name());
                for (SensorItem item : this.sensorItems) {
                    if (!item.getDevice().getSensorId().equals(message.getDeviceId()) || !item.getDeviceMessageType().equals((Object)message.getMessageType())) continue;
                    if (item.getOn() && !this.isEnabled) {
                        this.doEnable();
                    } else if (!item.getOn() && this.isEnabled) {
                        this.doDisable();
                    }
                    return;
                }
            } else if (EventUtil.isEventOfType((Event)event, (EventTopic)EventTopic.HOMECONTROL_DEVICES_CONFIGURATION_CHANGE_MESSAGE).booleanValue()) {
                log.debug((Object)"Reloading device cache");
                this.updateDevices(this.flatId);
            }
        }
        catch (Throwable ex) {
            log.error((Object)"Error while processing incoming event", ex);
        }
    }

    public final void handleValueChange(String key, ConfigurationValue valueOld, ConfigurationValue valueNew) {
        if (valueNew == null) {
            return;
        }
        if (key.equals(ConfigurationValueKey.FLAT_ID.getKey())) {
            try {
                this.flatId = valueNew.getIntegerValue();
                log.debug((Object)("Flat id received: " + this.flatId));
                this.updateDevices(this.flatId);
            }
            catch (Throwable ex) {
                log.error((Object)("Error while handling configuration value change for key '" + key + "'"), ex);
            }
        } else if (key.equals("at.creadoo.homer.processing.presence.enabled")) {
            try {
                boolean enabled = valueNew.getBooleanValue();
                if (!this.isEnabled && enabled) {
                    log.info((Object)"Enabled");
                    this.setEnabled(enabled);
                    this.updated(this.getConfiguration());
                } else if (this.isEnabled && !enabled) {
                    log.info((Object)"Disabled");
                    this.setEnabled(enabled);
                    this.unregister();
                }
            }
            catch (Throwable ex) {
                log.error((Object)("Error while handling configuration value change for key '" + key + "'"), ex);
            }
        }
    }

    public synchronized void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        if (properties != null) {
            this.updated(Util.toMap(properties));
        }
    }

    public synchronized void updated(Map<String, String> properties) throws ConfigurationException {
        if (properties != null) {
            LocalTime time;
            String timeValue;
            this.unregister();
            if (properties.containsKey("recalculation.time") && (timeValue = properties.get("recalculation.time").trim()) != null && !timeValue.isEmpty() && (time = Constants.TIME_PARSER.parseLocalTime(timeValue)) != null) {
                try {
                    DateTime executionTime = DateTime.now().withTime(time);
                    if (executionTime.isBefore((ReadableInstant)DateTime.now())) {
                        executionTime = executionTime.plusDays(1);
                    }
                    this.scheduler.fireJobAt(SCHEDULER_NAME_RECALCULATE, (Object)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                PresenceSimulatorImpl.this.updated(PresenceSimulatorImpl.this.getConfiguration());
                            }
                            catch (ConfigurationException ex) {
                                log.error((Object)"Error executing recalculation", (Throwable)ex);
                            }
                        }
                    }, null, executionTime.toDate());
                }
                catch (Exception ex) {
                    log.error((Object)"Error registering job", (Throwable)ex);
                }
            }
            this.process(properties);
        }
    }

    private void updateDevices(Integer flatId) {
        Map actuators;
        Map sensors = this.dataAccess.getSensorsByFlatIdAsMap(flatId);
        log.debug((Object)(sensors != null ? sensors.size() + " sensors found" : "No sensors found!"));
        this.sensors.clear();
        if (sensors != null) {
            this.sensors.putAll(sensors);
        }
        log.debug((Object)((actuators = this.dataAccess.getActuatorsByFlatIdAsMap(flatId)) != null ? actuators.size() + " actuators found" : "No actuators found!"));
        this.actuators.clear();
        if (actuators != null) {
            this.actuators.putAll(actuators);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(Map<String, String> properties) {
        Object actuatorProperties;
        if (this.isEnabled) {
            Object channel;
            String weatherWoeid = Util.getProperty(properties, "weather.woeid");
            if (!weatherWoeid.trim().isEmpty()) {
                channel = WeatherUtil.getWeatherForecast(weatherWoeid, DegreeUnit.CELSIUS);
                if (channel != null) {
                    log.debug((Object)channel.getDescription());
                    LocalTime sunrise = WeatherUtil.convertTime(channel.getAstronomy().getSunrise());
                    log.debug((Object)("SUNRISE: " + sunrise));
                    LocalTime sunset = WeatherUtil.convertTime(channel.getAstronomy().getSunset());
                    log.debug((Object)("SUNSET: " + sunset));
                    if (sunrise != null) {
                        Util.replaceProperty(properties, "<sunrise>", Constants.TIME_FORMAT.print((ReadablePartial)sunrise));
                    } else {
                        log.error((Object)"Error retrieving data for 'sunrise' from service");
                    }
                    if (sunset != null) {
                        Util.replaceProperty(properties, "<sunset>", Constants.TIME_FORMAT.print((ReadablePartial)sunset));
                    } else {
                        log.error((Object)"Error retrieving data for 'sunset' from service");
                    }
                } else {
                    log.error((Object)"Error retrieving weather data from service");
                }
            }
            channel = this.actuatorItems;
            synchronized (channel) {
                this.actuatorItems.clear();
            }
            channel = this.sensorItems;
            synchronized (channel) {
                this.sensorItems.clear();
            }
            actuatorProperties = Util.matchingSubset(properties, KEY_PREFIX_ACTUATOR, false);
            for (String key : actuatorProperties.keySet()) {
                String value = (String)actuatorProperties.get(key);
                List<String> keyParts = Arrays.asList(key.split("\\."));
                if (keyParts != null && keyParts.size() >= 2) {
                    block46: {
                        Object actuatorMessageType;
                        try {
                            Integer actuatorId = Integer.parseInt(keyParts.get(0));
                            actuatorMessageType = DeviceMessageType.valueOf((String)keyParts.get(1));
                            if (actuatorId == null || actuatorMessageType == null) {
                                log.error((Object)("Unable to parse entry with key 'actuator." + key + "'"));
                                continue;
                            }
                            log.debug((Object)("Actuator id: " + actuatorId));
                            log.debug((Object)("Actuator message type: " + actuatorMessageType));
                            if (!this.actuators.containsKey(actuatorId)) {
                                log.error((Object)("Unable to find actuator with id '" + actuatorId + "'"));
                                continue;
                            }
                            DBActuator actuator = this.actuators.get(actuatorId);
                            if (!DeviceMessageType.getFlagsForDeviceType((DeviceType)actuator.getDeviceType()).contains(actuatorMessageType)) {
                                log.error((Object)("Given DeviceMessageType '" + actuatorMessageType + "' not valid for actuator with id '" + actuatorId + "'"));
                                continue;
                            }
                            for (String time : value.split(",")) {
                                LocalTime startTime = Util.getStartTime(time);
                                LocalTime endTime = Util.getEndTime(time);
                                if (startTime == null) {
                                    log.error((Object)("Given time '" + time + "' not parsable"));
                                    continue;
                                }
                                if (endTime != null && startTime.isEqual((ReadablePartial)endTime)) {
                                    log.error((Object)"End time shouldn't be the same as start time");
                                    continue;
                                }
                                ActuatorItem presenceItem = new ActuatorItem(actuator, (DeviceMessageType)actuatorMessageType, startTime, endTime);
                                Set<ActuatorItem> set = this.actuatorItems;
                                synchronized (set) {
                                    this.actuatorItems.add(presenceItem);
                                }
                            }
                        }
                        catch (NumberFormatException ex) {
                            log.error((Object)"Unable to parse device id", (Throwable)ex);
                            continue;
                        }
                        int randomizeMinutes = 0;
                        if (keyParts.size() >= 3) {
                            try {
                                randomizeMinutes = Integer.parseInt(keyParts.get(2));
                                if (randomizeMinutes <= 0) break block46;
                                actuatorMessageType = this.actuatorItems;
                                synchronized (actuatorMessageType) {
                                    this.randomizeItems(this.actuatorItems, randomizeMinutes);
                                }
                            }
                            catch (NumberFormatException ex) {
                                // empty catch block
                            }
                        }
                    }
                    Set<ActuatorItem> ex = this.actuatorItems;
                    synchronized (ex) {
                        this.register(this.actuatorItems);
                        continue;
                    }
                }
                log.error((Object)("Given key '" + key + "' not valid"));
            }
        }
        Map<String, String> sensorProperties = Util.matchingSubset(properties, KEY_PREFIX_SENSOR, false);
        actuatorProperties = this.sensorItems;
        synchronized (actuatorProperties) {
            this.sensorItems.clear();
        }
        for (String key : sensorProperties.keySet()) {
            log.debug((Object)("Processing key '" + key + "'"));
            String value = sensorProperties.get(key);
            List<String> keyParts = Arrays.asList(key.split("\\."));
            if (keyParts != null && keyParts.size() >= 2) {
                try {
                    Integer sensorId = Integer.parseInt(keyParts.get(0));
                    DeviceMessageType sensorMessageType = DeviceMessageType.valueOf((String)keyParts.get(1));
                    if (sensorId == null || sensorMessageType == null) {
                        log.error((Object)("Unable to parse entry with key 'sensor." + key + "'"));
                        continue;
                    }
                    log.debug((Object)("Sensor id: " + sensorId));
                    log.debug((Object)("Sensor message type: " + sensorMessageType));
                    if (!this.sensors.containsKey(sensorId)) {
                        log.error((Object)("Unable to find sensor with id '" + sensorId + "'"));
                        continue;
                    }
                    DBSensor sensor = this.sensors.get(sensorId);
                    if (!DeviceMessageType.getFlagsForDeviceType((DeviceType)sensor.getDeviceType()).contains(sensorMessageType)) {
                        log.error((Object)("Given DeviceMessageType '" + sensorMessageType + "' not valid for sensor with id '" + sensorId + "'"));
                        continue;
                    }
                    SensorItem sensorItem = value != null && value.trim().equalsIgnoreCase("on") ? new SensorItem(sensor, sensorMessageType, true) : new SensorItem(sensor, sensorMessageType, false);
                    this.sensorItems.add(sensorItem);
                }
                catch (NumberFormatException ex) {
                    log.error((Object)"Unable to parse device id", (Throwable)ex);
                }
                continue;
            }
            log.error((Object)("Given key '" + key + "' not valid"));
        }
    }

    private void register(Set<ActuatorItem> presenceItems) {
        for (ActuatorItem item : presenceItems) {
            List deviceMessageTypes = DeviceMessageType.getFlagsForDeviceType((DeviceType)item.getDevice().getDeviceType());
            if (item.getEndTime() != null && deviceMessageTypes.size() > 2) {
                log.error((Object)("End time not possible for device '" + item.getDevice().getActuatorId() + "' which has " + deviceMessageTypes.size() + " possible DeviceMessageTypes"));
                continue;
            }
            if (item.getEndTime() == null) {
                this.schedulePresenceItem("actuator-" + item.getDevice().getActuatorId() + "-start-" + item.getStartTime(), item, item.getDeviceMessageType(), item.getStartTime());
                continue;
            }
            if (item.getEndTime() != null && LocalTime.now().isAfter((ReadablePartial)item.getStartTime()) && LocalTime.now().isBefore((ReadablePartial)item.getEndTime())) {
                this.postEvent(item, item.getDeviceMessageType());
                this.schedulePresenceItem("actuator-" + item.getDevice().getActuatorId() + "-end-" + item.getEndTime(), item, this.getOpposite(deviceMessageTypes, item.getDeviceMessageType()), item.getEndTime());
                continue;
            }
            this.schedulePresenceItem("actuator-" + item.getDevice().getActuatorId() + "-start-" + item.getStartTime(), item, item.getDeviceMessageType(), item.getStartTime());
            this.schedulePresenceItem("actuator-" + item.getDevice().getActuatorId() + "-end-" + item.getEndTime(), item, this.getOpposite(deviceMessageTypes, item.getDeviceMessageType()), item.getEndTime());
        }
    }

    private void randomizeItems(Set<ActuatorItem> actuatorItems, Integer randomMinutes) {
        RandomUtil rand = new RandomUtil();
        for (ActuatorItem item : actuatorItems) {
            item.setStartTime(item.getStartTime().plusMinutes(rand.nextInt(-1 * randomMinutes, randomMinutes)));
            if (item.getEndTime() == null) continue;
            LocalTime randomEndTime = item.getEndTime().plusMinutes(rand.nextInt(-1 * randomMinutes, randomMinutes));
            if (randomEndTime.isBefore((ReadablePartial)item.getStartTime())) {
                item.setEndTime(item.getStartTime().plusMinutes(1));
                continue;
            }
            item.setEndTime(randomEndTime);
        }
    }

    private DeviceMessageType getOpposite(List<DeviceMessageType> deviceMessageTypes, DeviceMessageType deviceMessageType) {
        if (deviceMessageTypes.size() == 2) {
            for (DeviceMessageType item : deviceMessageTypes) {
                if (item.equals((Object)deviceMessageType)) continue;
                return item;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedulePresenceItem(String name, final ActuatorItem item, final DeviceMessageType messageType, LocalTime time) {
        if (name == null || name.isEmpty() || item == null || messageType == null || time == null) {
            return;
        }
        this.scheduler.fireJobAt(name, (Object)new Runnable(){

            @Override
            public void run() {
                PresenceSimulatorImpl.this.postEvent(item, messageType);
            }
        }, null, DateTime.now().withTime(time).toDate(), 86400L);
        Map<String, ActuatorItem> map = this.scheduledJobs;
        synchronized (map) {
            this.scheduledJobs.put(name, item);
        }
    }

    private void postEvent(ActuatorItem item, DeviceMessageType messageType) {
        Event event = EventBuilder.createActuatorRequestEvent((DBActuator)item.getDevice(), (DeviceMessageType)messageType);
        log.info((Object)("Send device request for device '" + item.getDevice().getActuatorId() + "' and message type '" + messageType.name() + "'"));
        this.eventAdmin.postEvent(event);
    }

    private void doEnable() {
        if (this.isEnabled) {
            return;
        }
        try {
            log.info((Object)"Enabled");
            this.setEnabled(true);
            this.updated(this.getConfiguration());
        }
        catch (Throwable ex) {
            log.error((Object)"Error while enabling", ex);
        }
    }

    private void doDisable() {
        if (!this.isEnabled) {
            return;
        }
        try {
            log.info((Object)"Disabled");
            this.setEnabled(false);
            this.unregister();
        }
        catch (Throwable ex) {
            log.error((Object)"Error while enabling", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister() {
        this.scheduler.removeJob(SCHEDULER_NAME_RECALCULATE);
        Map<String, ActuatorItem> map = this.scheduledJobs;
        synchronized (map) {
            for (String name : this.scheduledJobs.keySet()) {
                this.scheduler.removeJob(name);
            }
            this.scheduledJobs.clear();
        }
    }

    private void registerService() {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        if (bundle == null) {
            return;
        }
        BundleContext bundleContext = bundle.getBundleContext();
        if (bundleContext == null) {
            return;
        }
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("service.pid", "at.creadoo.homer.processing.presence");
        this.serviceRegistration = bundleContext.registerService(ManagedService.class.getName(), (Object)this, properties);
    }

    private void unregisterService() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }
}

