package at.creadoo.homer.processing.presence.util;

import java.io.IOException;

import javax.xml.bind.JAXBException;

import org.apache.log4j.Logger;
import org.joda.time.LocalTime;

import com.github.fedy2.weather.YahooWeatherService;
import com.github.fedy2.weather.data.Channel;
import com.github.fedy2.weather.data.unit.DegreeUnit;
import com.github.fedy2.weather.data.unit.Time;
import com.github.fedy2.weather.data.unit.TimeConvention;

public class WeatherUtil {

	private static final Logger log = Logger.getLogger(WeatherUtil.class);

	public WeatherUtil() {
		//
	}

	public static final LocalTime convertTime(final Time time) {
		LocalTime result = null;
		if (time != null) {
			result = new LocalTime().withHourOfDay(time.getHours()).withMinuteOfHour(time.getMinutes()).withSecondOfMinute(0).withMillisOfSecond(0);
			if (time.getConvention().equals(TimeConvention.PM)) {
				result = result.plusHours(12);
			}
		}
		return result;
	}
	
	public static final Channel getWeatherForecast(final String woeid, final DegreeUnit unit) {
		try {
			final YahooWeatherService service = new YahooWeatherService();
			final Channel channel = service.getForecast(woeid, unit);
			return channel;
		} catch (JAXBException ex) {
			log.error("Error parsing weather data", ex);
		} catch (IOException ex) {
			log.error("Error parsing weather data", ex);
		}
		
		return null;
	}

}
